<?php

/**
 * Component: PLX 3 - Dynamic 2
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
  ],
  'query_args' => [],
  'terms' => [],
];

// Merge passed $args with defaults
$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
$ajax_id = 'blog_filter_' . uniqid();
?>

<div class="wrapper">
  <div class="layout_row">
    <div class="layout_column">
      <div class="column">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>
      </div>

      <div class="column">
        <?php if (is_array($props['terms']) && !empty($props['terms'])):
          component('terms', [
            'className' => '',
            'target' => 'filter.termFilter',
            'ajax' => [
              'action' => 'filter_posts_by_term',
              'callback' => 'slide_loader',
              'container' => $ajax_id,
              'query_args' => $props['query_args'],
              'nonce' => 'filter-posts-by-term'
            ],
            'terms' => $props['terms'],
          ]);
        endif; ?>
      </div>
    </div>

    <?php if ($posts_query->have_posts()): ?>
      <div class="layout_row">
        <div data-js-target="dynamicTwo.slides" id="c3FilterSlider">
          <div class="swiper" data-js-target="swiper.c3FilterSlider">
            <div class="swiper-wrapper <?= esc_attr($ajax_id) ?>">
              <?php while ($posts_query->have_posts()):
                $posts_query->the_post();
                $terms = get_the_terms(get_the_ID(), 'custom_post_type_2_category');
                $legacy_figure = get_the_post_thumbnail_url();
                $preview = get_field('preview') ?: [];
                $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;

                component('dynamic-two/slide-card', [
                  'id' => get_the_ID(),
                  'title' => get_the_title(),
                  'href' => esc_url(get_the_permalink()),
                  'terms' => $terms,
                  'figure' => $figure,
                ]);
              endwhile; ?>
            </div>
          </div>
        </div>

        <div class="controls variant--space-between" data-js-target="swiper.c3FilterSliderControls">
          <div class="swiper-progress">
            <div class="swiper-progress-index-first"></div>
            <div class="swiper-progress-bar"></div>
            <div class="swiper-progress-index-last"></div>
          </div>
          <div class="swiper-navigation">
            <button class="icon-button variant--secondary --prev">
              <span class="sr-only">Previous</span>
              <?= get_icon('chevron-left') ?>
            </button>
            <button class="icon-button variant--secondary --next">
              <span class="sr-only">Next</span>
              <?= get_icon('chevron-right') ?>
            </button>
          </div>
        </div>
      </div>

    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>
  </div>
</div>
