<?php

/**
 * Component: PLX 05 - Logo list
 * Variant: Slider
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'gallery' => [],
  'align' => null,
  'type' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$gallery = $props['gallery'];
?>

<div class="layout-block">
  <div class="layout-row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div class="<?= cn('logo-list', $props['type']) ?>">
      <div class="layout-row">
        <div class="swiper" data-js-target="swiper.c5Slider">
          <div class="swiper-wrapper">
            <?php foreach ($gallery as $image):
              $link = get_field('media_custom_url', $image['ID']); ?>
              <div class="swiper-slide">
                <?php if (!empty($link)): ?>
                  <a
                    href="<?= $link['url'] ?>"
                    target="<?= esc_attr($link['target'] ?: '_self') ?>"
                  >
                    <img
                      src="<?= esc_url($image['url']) ?>"
                      alt="<?= esc_attr($image['alt']) ?>"
                    />
                  </a>
                <?php else: ?>
                  <img
                    src="<?= esc_url($image['url']) ?>"
                    alt="<?= esc_attr($image['alt']) ?>"
                  />
                <?php endif; ?>
              </div>
            <?php
            endforeach; ?>
          </div>
        </div>

        <div class="controls variant--center" data-js-target="swiper.c5SliderControls">
          <div class="swiper-navigation">
            <button class="icon-button variant--secondary --prev">
              <span class="sr-only">Previous</span>
              <?= get_icon('chevron-left') ?>
            </button>
            <button class="icon-button variant--secondary --next">
              <span class="sr-only">Next</span>
              <?= get_icon('chevron-right') ?>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
