<?php

/**
 * Component: PLX 09 - Text / Image
 * Variant: BLOX
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
    'has_body' => $has_body,
    'body' => $body,
    'has_footer' => $has_footer,
    'button_group' => $button_group,
  ],
  'image' => $image,
  'align' => $align,
  'item_align' => $item_align,
  'item_reverse' => $item_reverse,
  'items' => $items,
] = $args;
?>

<div class="layout-block">
  <div class="layout-row">
    <div class="<?= cn('copy variant--section', $align) ?>">
      <?php if ($has_caption || $has_title): ?>
        <div class="copy--header">
          <?php if ($has_caption): ?>
            <p class="copy--caption"><?= $caption ?></p>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <h2 class="copy--title"><?= $title ?></h2>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if ($has_body): ?>
        <div class="copy--body">
          <div class="wysiwyg"><?= $body ?></div>
        </div>
      <?php endif; ?>

      <?php if ($has_footer && !empty($button_group)): ?>
        <div class="copy--footer">
          <div class="button-group">
            <?php foreach ($button_group as $button):
              $button_variant = match ($button['variant'] ?? null) {
                '0' => 'variant--primary',
                '1' => 'variant--secondary',
                '2' => 'variant--ghost',
                '3' => 'variant--white',
                '4' => 'variant--link',
                default => null,
              };

              if ($button['link']): ?>
                <a
                  class="<?= cn('button', $button_variant) ?>"
                  href="<?= esc_url($button['link']['url']) ?>"
                  target="<?= $button['link']['target'] ?>"
                >
                  <?= $button['link']['title'] ?>
                </a>
              <?php endif;
            endforeach; ?>
          </div>
        </div>
      <?php endif; ?>
    </div>

    <div
      class="<?= cn('layout-column', $item_align, $item_reverse) ?>"
      data-columns="2,2"
      data-gap="xl"
    >
      <?php if (!empty($items)): ?>
        <div class="list">
          <ul class="list--list">
            <?php foreach ($items as $item): ?>
              <li class="list--item">
                <div class="copy">
                  <?php if ($item['item_title']): ?>
                    <div class="copy--header">
                      <h3 class="copy--title"><?= $item['item_title'] ?></h3>
                    </div>
                  <?php endif; ?>

                  <?php if ($item['item_body']): ?>
                    <div class="copy--body">
                      <div class="wysiwyg"><?= $item['item_body'] ?></div>
                    </div>
                  <?php endif; ?>

                  <?php if ($item['has_footer'] && !empty($item['button_group'])): ?>
                    <div class="copy--footer">
                      <div class="button-group">
                        <?php foreach ($item['button_group'] as $button): ?>
                          <a
                            href="<?= esc_url($button['button_link']['url']) ?>"
                            target="<?= esc_attr($button['button_link']['target'] ?: '_self') ?>"
                            class="<?= cn(
                              'button',
                              !empty($button['button_variant']) ? 'variant--' . $button['button_variant'] : ''
                            ) ?>"
                          >
                            <?= esc_html($button['button_link']['title']) ?>
                          </a>
                        <?php endforeach; ?>
                      </div>
                    </div>
                  <?php endif; ?>
                </div>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <div class="figure">
        <?php if (!empty($image)): ?>
          <img src="<?= esc_url($image['url']) ?>" alt="<?= esc_attr($image['alt']) ?>" />
        <?php else: ?>
          <img
            src="<?= get_template_directory_uri() ?>/assets/images/placeholder-demo.png"
            alt="Place your image here"
          >
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
