<?php

/**
 * Component: PLX 10 - Image Gallery
 * Variant: Default
 */

$passed_args = $args ?? [];

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'gallery' => [],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $passed_args);

$gallery = $props['gallery'];
?>

<div class="wrapper">
  <div class="layout_row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>


    <?php if ($gallery): ?>
      <ul class="gallery" data-js-controller="gallery">
        <?php foreach ($gallery as $index => $image): ?>
          <li class="gallery-item" data-js-target="gallery.item" data-index="<?= $index ?>">
            <img
              src="<?= esc_url($image['url']) ?>"
              alt="<?= esc_attr($image['alt']) ?>"
            />
          </li>
        <?php endforeach; ?>
      </ul>

      <section class="modal" data-js-controller="modal" data-is-open="false">
        <div class="modal--background" data-js-target="modal.background"></div>

        <div class="modal--container" data-js-target="modal.container">
          <div class="lightbox--container">
            <div class="swiper" data-js-target="swiper.lightbox">
              <div class="swiper-wrapper">
                <?php foreach ($gallery as $image): ?>
                  <div class="swiper-slide">
                    <img
                      src="<?= esc_url($image['url']) ?>"
                      alt="<?= esc_attr($image['alt']) ?>"
                    />
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
        </div>

        <div class="modal--controls" data-js-target="swiper.lightboxControls">
          <button class="icon-button variant--white --prev">
            <span class="sr-only">Previous</span>
            <?= get_icon('chevron-left') ?>
          </button>
          <button class="icon-button variant--white --next">
            <span class="sr-only">Next</span>
            <?= get_icon('chevron-right') ?>
          </button>
        </div>
      </section>
    <?php endif; ?>

  </div>
</div>
