<?php

/**
 * Component: PLX 12 - Vertical Carousel
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'items' => [],
  'image' => [],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$items = $props['items'];
$figure = $props['image'];
?>

<div class="layout-block">
  <div class="layout-row">

    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <div class="c12-card">
      <?php if (!empty($items)): ?>
        <div class="main">

          <div class="controls" data-js-target="swiper.c12SliderControls">
            <div class="pagination"></div>
          </div>

          <div class="content">
            <div class="swiper" data-js-target="swiper.c12Slider">
              <div class="swiper-wrapper">
                <?php foreach ($items as $item): ?>
                  <div class="swiper-slide">
                    <?php component('copy', [
                      'type' => 'variant--subsection',
                      'has_caption' => !empty($item['caption']),
                      'caption' => $item['caption'],
                      'has_title' => !empty($item['title']),
                      'title' => $item['title'],
                      'has_body' => !empty($item['content']),
                      'body' => $item['content'],
                      'has_footer' => !empty($item['link']),
                      'button_group' => [
                        [
                          'variant' => '4',
                          'link' => [
                            'title' => !empty($item['link']['title']) ? $item['link']['title'] : null,
                            'url' => !empty($item['link']['url']) ? $item['link']['url'] : null,
                          ],
                        ],
                      ],
                    ]); ?>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

        </div>

        <div class="canvas">
          <?php if (!empty($figure['provider'])): ?>
            <?php component('figure', [
              'src' => $figure,
              'type' => 'fill',
              'shape' => 'rounded',
            ]); ?>
          <?php elseif (!empty($figure)): ?>
            <div class="figure" data-variant="fill" data-shape="rounded">
              <img src="<?= esc_url($figure['url']) ?>" class="w-full h-full">
            </div>
          <?php else: ?>
            <span class="figure-placeholder" data-label="Upload Image"></span>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>

  </div>
</div>


