<?php

/**
 * Component: PLX 13 - Testimonials
 * Variant: BLOX
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
    'has_body' => $has_body,
    'body' => $body,
    'has_footer' => $has_footer,
    'button_group' => $button_group,
  ],
  'image' => $image,
  'query_args' => $query_args,
  'type' => $type,
] = $args;

$query = new WP_Query($query_args);
?>

<div class="layout-block">
  <div class="layout-row">
    <div class="<?= cn('copy variant--section') ?>">
      <?php if ($has_caption || $has_title): ?>
        <div class="copy--header">
          <?php if ($has_caption): ?>
            <p class="copy--caption"><?= $caption ?></p>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <h2 class="copy--title"><?= $title ?></h2>
          <?php endif; ?>
        </div>
      <?php endif; ?>

      <?php if ($has_body): ?>
        <div class="copy--body">
          <div class="wysiwyg"><?= $body ?></div>
        </div>
      <?php endif; ?>

      <?php if ($has_footer && !empty($button_group)): ?>
        <div class="copy--footer">
          <div class="button-group">
            <?php foreach ($button_group as $button):
              $button_variant = match ($button['variant'] ?? null) {
                '0' => 'variant--primary',
                '1' => 'variant--secondary',
                '2' => 'variant--ghost',
                '3' => 'variant--white',
                '4' => 'variant--link',
                default => null,
              };

              if ($button['link']): ?>
                <a
                  class="<?= cn('button', $button_variant) ?>"
                  href="<?= esc_url($button['link']['url']) ?>"
                  target="<?= $button['link']['target'] ?>"
                >
                  <?= $button['link']['title'] ?>
                </a>
              <?php endif;
            endforeach; ?>
          </div>
        </div>
      <?php endif; ?>
    </div>


    <div class="testimonial_layout">

      <div class="testimonial">
        <?php if ($query->have_posts()): ?>
          <div class="swiper" data-js-target="swiper.testimonial.varBlox">
            <div class="swiper-wrapper">
              <?php while ($query->have_posts()): ?>
                <?php
                $query->the_post();
                $quote = get_field('testimonial_quote');
                $name = get_field('testimonial_name');
                $position = get_field('testimonial_position');
                ?>
                <div class="swiper-slide">
                  <blockquote class="quote">
                    <?php if ($quote): ?>
                      <div class="quote--body"><?= $quote ?></div>
                    <?php endif; ?>
                    <?php if ($name || $position): ?>
                      <div class="quote--attribution">
                        <span class="quote--author"><?= $name ?></span>
                        <span><?= $position ?></span>
                      </div>
                    <?php endif; ?>
                  </blockquote>
                </div>
              <?php endwhile; ?>
            </div>
          </div>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>

        <div class="controls variant--space-between" data-js-target="swiper.testimonial.varBloxControls">
          <div class="swiper-progress">
            <div class="swiper-progress-index-first"></div>
            <div class="swiper-progress-bar"></div>
            <div class="swiper-progress-index-last"></div>
          </div>
          <div class="swiper-navigation">
            <button class="icon-button variant--secondary --prev">
              <span class="sr-only">Previous</span>
              <?= get_icon('chevron-left') ?>
            </button>
            <button class="icon-button variant--secondary --next">
              <span class="sr-only">Next</span>
              <?= get_icon('chevron-right') ?>
            </button>
          </div>
        </div>
      </div>

      <div class="graphic">
        <?php if (!empty($image)): ?>
          <div class="figure-wrapper">
            <div class="figure">
              <img src="<?= $image['url'] ?>" alt="<?= $image['alt'] ?>" />
            </div>
          </div>
        <?php endif; ?>
      </div>

    </div>

  </div>
</div>
