<?php

/**
 * Component: PLX 15 - Video
 * Variant: Full Width
 */

$args = $args ?? [];
[
  'has_caption' => $has_caption,
  'caption' => $caption,
  'has_title' => $has_title,
  'title' => $title,
  'has_body' => $has_body,
  'body' => $body,
  'has_footer' => $has_footer,
  'button_group' => $button_group,
  'align' => $align,
] = $args['content'];
[
  'provider' => $provider,
  'src_local' => $src_local,
  'src_vimeo' => $src_vimeo,
  'src_youtube' => $src_youtube,
] = $args['figure'];
?>

<div class="layout-block">
    <div class="layout-row">

        <div class="<?= cn('copy variant--section', $align) ?>">
            <?php if ($has_caption || $has_title): ?>
                <div class="copy--header">
                    <?php if ($has_caption): ?>
                        <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                        <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ($has_body): ?>
                <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                </div>
            <?php endif; ?>
            <?php if ($has_footer): ?>
                <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                        <div class="button-group">
                            <?php foreach ($button_group as $i => $button): ?>
                                <?php $button_variant = match ($button['variant'] ?? null) {
                                  '0' => 'variant--primary',
                                  '1' => 'variant--secondary',
                                  '2' => 'variant--ghost',
                                  '3' => 'variant--white',
                                  '4' => 'variant--link',
                                  default => null,
                                }; ?>
                                <?php if ($button['link']): ?>
                                    <a
                                            class="<?= cn('button', $button_variant) ?>"
                                            href="<?= esc_url($button['link']['url']) ?>"
                                            target="<?= $button['link']['target'] ?>"
                                    >
                                        <?= $button['link']['title'] ?>
                                    </a>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <div>
          <?php
          $vimeoOptions = [
            'badge' => 0,
            'autopause' => 0,
            'player_id' => 0,
            'app_id' => 58479,
            'allow' => 'autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media',  // Default allowed attributes
          ];

          echo get_figure($args['figure'], 'figure',$vimeoOptions); ?>

        </div>

    </div>
</div>
