<?php

/**
 * Component: PLX 17 - Cards
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'cards' => [],
  'type' => '',
  'align' => '',
  'custom' => [],
  'icon' => [
    'has_background' => true,
    'size' => 20,
  ],
];

$props = array_merge_deep($_query, $args ?? []);
?>

<div class="wrapper">
  <div class="layout_row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if (!empty($props['cards'])): ?>
      <div class="cards_grid">
        <?php foreach ($props['cards'] as $card): ?>
            <?php component('card', [
              'icon' => [
                'provider' => 'acf',
                'src' => $card['icon_lib'],
                'has_background' => $props['icon']['has_background'],
                'size' => $props['icon']['size'],
              ],
              'heading' => $card['title'],
              'description' => $card['excerpt'],
              'href' => !empty($card['link']['url']) ? esc_url($card['link']['url']) : '',
              'has_border' => true,
              'cta' => !empty($card['link']['title']) ? $card['link']['title'] : '',
              'align' => $props['align'],
            ]); ?>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
