<?php

/**
 * Component: PLX 22 - Calendar
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'align' => '',
  'custom' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="layout-block">
  <div class="calendar-layout">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <?php if ($posts_query->have_posts()): ?>
      <div class="event-layout">
        <?php while ($posts_query->have_posts()): ?>
          <?php
          $posts_query->the_post();
          $data = [
            'content' => [
              'title' => get_the_title(),
              'date' => get_field('date'),
              'time' => get_field('time'),
              'link' => get_field('link'),
              'desc' => wp_trim_words(get_field('description'), 20, '...'),
            ],
            'type' => $props['type'],
          ];
          $today = date('Ymd');
          $current_year = date('Y');
          $year = date('Y', strtotime($data['content']['date']));
          $date_current = $data['content']['date'] == $today ? 'current' : null;
          $time = $data['content']['time'];
          $description = $data['content']['desc'];
          ?>
          <a href="<?= esc_url($data['content']['link']) ?>">
            <article class="event">
              <aside class="<?= cn('event-date', $date_current) ?>">
                <div class="copy variant--subsection">
                  <div class="copy--header">
                    <h4 class="copy--title">
                      <?php if ($year === $current_year): ?>
                        <?= date('F j', strtotime($data['content']['date'])) ?>
                      <?php else: ?>
                        <?= date('F j, Y', strtotime($data['content']['date'])) ?>
                      <?php endif; ?>
                    </h4>
                  </div>
                  <?php if (!empty($time)): ?>
                    <div class="copy--body">
                      <p><?= date('g:i A', strtotime($time)) ?></p>
                    </div>
                  <?php endif; ?>
                </div>
              </aside>

              <main class="event-content">
                <div class="copy variant--subsection">
                  <div class="copy--header">
                    <h3 class="copy--title"><?= $data['content']['title'] ?></h3>
                  </div>
                  <?php if (!empty($description)): ?>
                    <div class="copy--body">
                      <div class="wysiwyg"><?= $description ?></div>
                    </div>
                  <?php endif; ?>
                </div>
              </main>
            </article>
          </a>
        <?php endwhile; ?>
      </div>
    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
