<?php

/**
 * Component: PLX 23 - Blog
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'terms' => [],
  'type' => '',
  'align' => '',
  'custom' => [
    'show_author' => false,
  ],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
$max_pages = $posts_query->max_num_pages;
$ajax_id = 'blog_pagination_' . uniqid();
$base_comp_args = [
  'type' => $props['type'],
  'show_author' => false,
];
?>

<div class="layout-block">
  <div class="layout-row">
    <div class="layout_column">
      <div class="column">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>
      </div>

      <div class="column">
        <?php if (is_array($props['terms']) && !empty($props['terms'])):
          component('terms', [
            'className' => '',
            'target' => 'filter.termFilter',
            'ajax' => [
              'action' => 'filter_posts_by_term',
              'callback' => 'blog_loader',
              'container' => $ajax_id,
              'query_args' => $props['query_args'],
            ],
            'terms' => $props['terms'],
          ]);
        endif; ?>
      </div>
    </div>
    <?php if ($posts_query->have_posts()): ?>
      <div class="blog-layout <?= esc_attr($ajax_id) ?>" id="<?= esc_attr($ajax_id) ?>">
        <?php while ($posts_query->have_posts()):
          $posts_query->the_post();
          $args = array_merge($base_comp_args, [
            'title' => get_the_title(),
            'link' => get_the_permalink(),
            'date' => get_localized_date(),
            'feat_image' => get_feat_img(),
            'author_image' => get_field('user_image', 'user_' . get_post_field('post_author')),
            'author_name' => get_author_full_name(),
          ]);
          component('blog/blog-card', $args);
        endwhile; ?>
      </div>

      <?php if ($max_pages > 1): ?>
        <?php component('pagination', [
          'type' => 'load-more',
          'ajax' => [
            'callback' => 'blog_loader',
            'container' => $ajax_id,
            'query_args' => $props['query_args'],
            'component_args' => $base_comp_args,
          ],
          'options' => [
            'per_page' => 12,
            'max_pages' => $max_pages,
          ],
        ]); ?>
      <?php endif; ?>

    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>

  </div>
</div>
