<?php

/**
 * Component: PLX 24 - Cards Parallax
 * Variant: Aside
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'cards' => [],
  'type' => '',
  'align' => '',
  'custom' => [
    'reduce_motion' => false,
  ],
];

$props = array_merge_deep($_query, $args ?? []);

$cards = $props['cards'];
?>

<div class="layout-block">
  <div
    class="<?= cn('card-stack_layout', $props['type']) ?>"
    <?= attr_if('data-motion', $props['custom']['reduce_motion'] ? 'reduced' : null) ?>
  >

    <div class="intro">
      <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => 'align--center']); ?>
    </div>

    <div class="stack">
      <?php foreach ($cards as $index => $card): ?>
        <?php
        $caption = $card['caption'];
        $title = $card['title'];
        $image = $card['image'];
        $content = $card['content'];
        $card_background_color = $card['color_background'];
        $card_text_color = $card['color_text'];
        $card_background = !empty($card_background_color) ? '--card-background: ' . $card_background_color . ';' : '';
        $card_text = !empty($card_text_color) ? '--card-text: ' . $card_text_color . ';' : '';
        $custom_card_color = !empty($card_text_color) || !empty($card_background_color);
        $custom_card_color_class = $custom_card_color ? ' has--custom-color' : '';
        ?>
        <div class="card-container">
          <div
            class="<?= cn('card', 'has-border', $custom_card_color_class) ?>"
            style="
              --offset: <?= $index * 18 ?>px;
              <?= $card_background ?>
              <?= $card_text ?>
            "
          >
            <div class="card_layout">
              <div class="content">
                <?php component('copy', [
                  'type' => 'variant--subsection',
                  'has_caption' => !empty($caption),
                  'caption' => $caption,
                  'has_title' => !empty($title),
                  'title' => $title,
                  'has_body' => !empty($content),
                  'body' => $content,
                ]); ?>
              </div>
              <div class="figure" data-variant="parallax" data-shape="rounded">
                <div class="figure_inner">
                  <img
                    src="<?= esc_url($image['url']) ?>"
                    alt="<?= esc_attr($image['alt']) ?>"
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
