<?php

/**
 * Component: PLX 25 - Table
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'table' => [],
  'align' => '',
  'type' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$table = $props['table'];
$table_head = $table['table_head'];
$table_body = $table['table_body'];
?>

<div class="layout-block">
  <div class="layout-row">
    <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'align' => $props['align']]); ?>

    <table class="table">
      <?php if (!empty($table_head)): ?>
        <thead>
          <tr class="table_block">
            <th class="table_block-title">
              <?= $table_head['thead_1'] ?>
            </th>
            <th class="table_block-title">
              <?= $table_head['thead_2'] ?>
            </th>
            <th class="table_block-title">
              <?= $table_head['thead_3'] ?>
            </th>
            <th class="table_block-title">
              <?= $table_head['thead_4'] ?>
            </th>
          </tr>
        </thead>
      <?php endif; ?>
      <?php if (!empty($table_body)): ?>
        <tbody>
        <?php foreach ($table_body as $group): ?>
          <?php $row = $group['row']; ?>
          <tr class="table_row">
            <th class="table_row-heading">
              <p><?= $row['cell_1'] ?></p>
            </th>
            <td class="table_row-cell">
              <p><?= $row['cell_2'] ?></p>
            </td>
            <td class="table_row-cell">
              <p><?= $row['cell_3'] ?></p>
            </td>
            <td class="table_row-cell">
              <p><?= $row['cell_4'] ?></p>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      <?php endif; ?>
    </table>
  </div>
</div>

