<?php

/**
 * Component: PLX 27 - Team
 * Variant: Aside
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
    'has_body' => false,
    'body' => '',
    'has_footer' => false,
    'button_group' => [],
  ],
  'query_args' => [],
  'type' => '',
  'align' => '',
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
?>

<div class="wrapper">
  <div class="layout_column" data-columns="<?= $posts_query->post_count === 1 ? '2,2' : '1,3' ?>">
    <div class="column col-title">
      <div class="col-title_inner">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>
      </div>
    </div>

    <div class="column col-team">
      <?php if ($posts_query->have_posts()): ?>
        <div class="col-team_layout <?= $posts_query->post_count === 1 ? 'col-team_layout_col_1' : "" ?>">
          <?php while ($posts_query->have_posts()): ?>
          <?php $posts_query->the_post(); ?>
            <?php
            $name = get_the_title();
            $link = get_the_permalink();
            $content = get_field('content');
            $figure = get_field('figure');
            $has_child = get_field('has_child');
            ?>
            <div class="team-member">
              <div
                class="team-member_headshot"
                x-data="{ modalExpanded: false }"
                @click="modalExpanded = !modalExpanded"
                :aria-expanded="modalExpanded"
              >
                <div class="team-member_media">
                  <?php component('figure', [
                    'src' => $figure,
                    'type' => 'fill',
                  ]); ?>
                </div>

                <?php if (!$has_child && !empty($content['description'])): ?>
                  <div class="team-member_modal">
                    <div class="team-member_modal_indicator">
                      <span class="bg" aria-hidden="true"></span>
                      <span class="line" aria-hidden="true" data-position="x"></span>
                      <span class="line" aria-hidden="true" data-position="y"></span>
                    </div>
                    <div class="team-member_modal_content">
                      <div class="wysiwyg">
                        <?= $content['description'] ?>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
              </div>
              <div class="team-member_content">
                <div class="stack" data-gap="4">
                  <?php component('typography/heading', [
                    'size' => 4,
                    'as' => 'h3',
                    'text' => esc_html($name),
                  ]); ?>
                  <?php if (!empty($content['position'])): ?>
                    <p class="position"><?= $content['position'] ?></p>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile; ?>
        </div>
      <?php else: ?>
        <?php component('error-boundary', [
          'title' => 'No Posts Found',
          'details' => 'Add posts, or remove this block.',
        ]); ?>
      <?php endif; ?>
      <?php wp_reset_postdata(); ?>
    </div>
  </div>
</div>

