<?php

/**
 * Blog Card
 * @param array $args
 */

$_defaults = [
  'type' => '',
  'date' => '',
  'title' => '',
  'link' => '',
  'show_feat_image' => true,
  'feat_image' => '',
  'show_author' => false,
  'author_image' => '',
  'author_name' => '',
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<a href="<?= esc_url($link) ?>">
  <article class="<?= cn('blog-card', $type) ?>">
    <div class="blog-card_figure">
      <?php if ($feat_image['url']): ?>
        <div class="figure" data-variant="fill">
          <div class="figure_inner">
            <?= $feat_image['full_tag'] ?>
          </div>
        </div>
      <?php else: ?>
        <div class="placeholder"><?= esc_html($title) ?></div>
      <?php endif; ?>
    </div>

    <div class="blog-card_content">
      <?php component('copy', [
        'type' => 'variant--subsection',
        'has_caption' => !empty($date),
        'caption' => $date,
        'has_title' => !empty($title),
        'title' => $title,
      ]); ?>
    </div>
  </article>
</a>
