<?php

/**
 * Button
 * @param array $args
 */

$_defaults = [
  'type' => 'primary',
  'size' => 'medium',
  'shape' => '',
  'link' => [
    'title' => '',
    'url' => null,
    'target' => null,
  ],
  'className' => '',
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);

$target = !empty($link['target']) ? $link['target'] : '';
?>

<a
  class="<?= cn('button', $className) ?>"
  <?= attr_if('data-variant', $type) ?>
  <?= attr_if('data-size', $size) ?>
  <?= attr_if('data-shape', $shape) ?>
  href="<?= esc_url($link['url']) ?>"

  <?php if (!empty($link['target'])): ?>
    target="<?= esc_attr($link['target']) ?>"
    <?php if ($link['target'] === '_blank'): ?>
      rel="noopener noreferrer"
    <?php endif; ?>
  <?php endif; ?>
>
  <span><?= esc_html($link['title']) ?></span>

  <?php if ($type == 'link'): ?>
    <?= get_icon('arrow-expand-right') ?>
  <?php endif; ?>
</a>
