<?php

/**
 * Copy
 *
 * Serves as a main text wrapper
 *
 * @param array $args
 */

$_defaults = [
  'has_icon' => false,
  'icon' => [
    'provider' => '',
    'src' => '',
    'color' => 'default',
    'has_background' => false,
    'has_border' => false,
    'shape' => '',
    'size' => 20,
  ],
  'has_caption' => false,
  'caption' => '',
  'has_title' => false,
  'title' => '',
  'has_body' => false,
  'body' => '',
  'has_footer' => false,
  'button_group' => [],
  'type' => '',
  'align' => '',
  'className' => '',
  'heading_tag' => 'h2',
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<div class="<?= cn('copy', $type, $align, $className) ?>">
  <?php if ($has_caption || $has_title || $has_icon): ?>
    <div class="copy--header">
      <?php if ($has_icon && !empty($icon['src']['type'])): ?>
        <div class="copy--icon">
          <?php component('icon', [
            'data' => ['provider' => $icon['provider'], 'src' => $icon['src']],
            'has_background' => $icon['has_background'],
            'has_border' => $icon['has_border'],
            'shape' => $icon['shape'],
            'size' => $icon['size'],
          ]); ?>
        </div>
      <?php endif; ?>
      <?php if ($has_caption && !empty($caption)): ?>
        <p class="copy--caption">
          <?= esc_html($caption) ?>
        </p>
      <?php endif; ?>
      <?php if ($has_title && !empty($title)): ?>
        <<?= $heading_tag ?> class="copy--title">
          <?= esc_html($title) ?>
        </<?= $heading_tag ?>>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if ($has_body && !empty($body)): ?>
    <div class="copy--body">
      <div class="wysiwyg"><?= wp_kses_post($body) ?></div>
    </div>
  <?php endif; ?>

  <?php if ($has_footer && !empty($button_group)): ?>
    <div class="copy--footer">
      <?php component('button-group', $button_group); ?>
    </div>
  <?php endif; ?>
</div>
