<?php
/**
 * Slide Card (Swiper Slide)
 * @param array $args
 */

$_defaults = [
  'id' => 0,
  'title' => '',
  'href' => '',
  'terms' => [],
  'figure' => '',
  'index' => '',
];

$params = array_merge_deep($_defaults, $args ?? []);
extract($params);

$term_ids = is_array($terms) ? implode(',', wp_list_pluck($terms, 'term_id')) : '';
?>

<div class="swiper-slide" data-terms="<?= esc_attr($term_ids) ?>">
  <a href="<?= $href ?>">
    <div class="layout_row" data-gap="small">
      <div class="canvas" data-hover="true">
        <?php if (!empty($figure['provider'])): ?>
          <?php component('figure', [
            'src' => $figure,
            'type' => 'fill',
            'shape' => 'rounded',
          ]); ?>
        <?php elseif (!empty($figure)): ?>
          <div class="figure" data-variant="fill" data-shape="rounded">
            <div class="figure_inner">
              <img src="<?= esc_url($figure) ?>">
            </div>
          </div>
        <?php else: ?>
          <span class="figure-placeholder" data-label="Upload Image"></span>
        <?php endif; ?>
        <?php
        component('dynamic-two/slide-card-hover-block', [
          'title' => $title,
          'terms' => $terms,
        ]);
        ?>
      </div>
      <?php if (!empty($title)): ?>
        <div class="variant--detail">
          <p><?= '/'.esc_html($index) ?></p>
          <h3><?= esc_html($title) ?></h3>
        </div>
      <?php endif; ?>
    </div>
  </a>
</div>
