<?php
/**
 * Slide Card (Swiper Slide)
 *
 * @param array $args
 */

$_defaults = [
  'title' => '',
  'href' => '',
  'terms' => [],
];

$params = array_merge_deep($_defaults, $args ?? []);
extract($params);

$term_ids = is_array($terms) ? implode(',', wp_list_pluck($terms, 'term_id')) : '';
?>

<div class="copy dynamic-2-hover_block">

  <?php if (!empty($title)): ?>
    <h3 class="copy--title"><?= esc_html($title) ?></h3>
  <?php endif; ?>

  <?php if (!empty($terms)): ?>
    <div class="copy--caption">
      <ul class="c3-current-filter-terms">
        <?php foreach ($terms as $term): ?>
          <li><?= esc_html($term->name) ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

</div>
