<?php

/**
 * Component: Colophon
 * @see footer
 */

$social_media_accounts = get_theme_option('social_media_accounts') ?? [];
$brand_name = get_site_info('name');
$colophon = get_theme_option('colophon');
$colophon_credits = $colophon['credits'] ?? [];
$colophon_links = $colophon['links'] ?? [];
?>

<div class="section-footer-row">
  <div class="colophon">
    <p>
      <?= date('Y') ?>	&copy;
      <?= $brand_name ?>.
    </p>

    <?php if (!empty($colophon_links)): ?>
      <?php foreach ($colophon_links as $item): ?>
        <a href="<?= $item['link']['url'] ?>"><?= $item['link']['title'] ?></a>
      <?php endforeach; ?>
    <?php endif; ?>

    <?php if (!empty($colophon_credits['enable'])): ?>
      <div class="credits stack" data-direction="horizontal" data-gap="4" data-align="center">
        <span class="credits_plx" >
          <a
            class="stack"
            data-direction="horizontal"
            data-align="center"
            href="https://plexible.com/"
            rel="noopener noreferrer"
          >
            <?php _e('Website by', 'plexible-theme-terms_misc'); ?> <?= get_icon('plexible') ?>
          </a>
        </span>

        <?php if (!empty($colophon_credits['partner'])): ?>
          <?php
          $name = $colophon_credits['partner']['name'];
          $logo = $colophon_credits['partner']['logo'];
          $link = $colophon_credits['partner']['link'];
          ?>
          <?php if (!empty($logo) || !empty($name) || !empty($link)): ?>
            <span class="credits_x">
              <div class="line"></div>
              <div class="line"></div>
            </span>
          <?php endif; ?>
          <span class="credits_partner">
            <?php if (!empty($logo) || !empty($name) || !empty($link)): ?>
              <a href="<?= $link ?>" target="_blank" rel="noopener noreferrer">
                <img src="<?= $logo ?>" alt="<?= $name ?> logo" />
              </a>
            <?php elseif (!empty($logo) || !empty($name)): ?>
              <img src="<?= $logo ?>" alt="<?= $name ?> logo" />
            <?php elseif (!empty($name)): ?>
              <p><?= $name ?></p>
            <?php endif; ?>
          </span>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
