<?php
$global = $args;
$social_media_label = get_field('contact_social_label', 'options');
$social_media = get_field('social_media_accounts', 'options');
$site_name = get_bloginfo('name');
$email = get_field('contact_email', 'options');
$phone = get_field('contact_phone', 'options');
$address = get_field('contact_address', 'options');
$brand_name = get_site_info('name');
$brand_logo = get_theme_option('brand_logo');
$brand_logo_alt = get_theme_option('brand_logo_alt');
$home_url = home_url('/');
$newsletter_id = get_field('newsletter_id', 'options');

$has_column_1 = get_field('has_column_1', 'options');
$column_1 = get_field('column_1', 'options');
$has_column_2 = get_field('has_column_2', 'options');
$column_2 = get_field('column_2', 'options');
$has_column_3 = get_field('has_column_3', 'options');
$column_3 = get_field('column_3', 'options');
$has_column_4 = get_field('has_column_4', 'options');
$column_4 = get_field('column_4', 'options');

$has_privacy_policy = get_field('has_privacy_policy', 'options');
$privacy_policy = get_field('privacy_policy_page', 'options');
$has_terms = get_field('has_terms', 'options');
$terms = get_field('terms_page', 'options');

$social_media_accounts = get_theme_option('social_media_accounts') ?? [];
$dev_settings = get_theme_option('dev');


?>
<div class="layout-block">
  <div class="footer-wrap-left">
    <nav class="section-footer-layout">
      <?php
      $columns = [
        'column_1' => ['has' => $has_column_1, 'value' => $column_1],
        'column_2' => ['has' => $has_column_2, 'value' => $column_2],
        'column_3' => ['has' => $has_column_3, 'value' => $column_3],
        'column_4' => ['has' => $has_column_4, 'value' => $column_4],
      ];
      if ($theme = get_field('footer_opt_theme', 'options')) {
        $footer = ['theme' => match ($theme ?? null) {
          '0' => null,
          '1' => 'light',
          '2' => 'dark',
          default => null,
        }];
      }
      ?>

      <div class="section-footer-column">
        <div class="footer-brand">
          <?php if ($brand_logo): ?>
            <?php if (($footer['theme'] == 'dark' && !empty($brand_logo_alt)) || ($footer['theme'] == null && $global['default_theme'] == 'dark' && !empty($brand_logo_alt))) : ?>
              <div class="brand-logo">
                <a href="<?= $home_url ?>">
                  <img src="<?= $brand_logo_alt ?>" alt="<?= $site_name ?> logo alternate"/>
                </a>
              </div>
            <?php else: ?>
              <a class="brand-logo" href="<?= esc_url($home_url) ?>">
                <img src="<?= $brand_logo ?>" alt="<?= $site_name ?> logo"/>
              </a>
            <?php endif; ?>
          <?php else: ?>
            <a class="brand-name" href="<?= esc_url($home_url) ?>">
              <h1><?= $brand_name ?></h1>
            </a>
          <?php endif; ?>
        </div>
      </div>
        <div class="columns-wrapper">
          <?php foreach ($columns as $column => $data): ?>
            <?php if ($data['has']):
              if($data['value'] === 'contact' || $data['value'] === 'newsletter') continue; ?>
              <div class="cols">
                <div class="list">
                  <?php if(wp_get_nav_menu_name($data['value'])): ?>
                    <h4 class="list--title">
                      <?= wp_get_nav_menu_name($data['value']) ?>
                    </h4>
                  <?php endif;?>
                  <?php wp_nav_menu([
                    'theme_location' => $data['value'],
                    'menu_class' => 'list--list',
                    'container' => false,
                  ]); ?>
                </div>
              </div>
            <?php endif; ?>
          <?php endforeach; ?>
        </div>
    </nav>
    <div class="colophon-desktop-version">
      <?php component('footer/colophon-option-2'); ?>
    </div>
  </div>
  <div class="footer-wrap-right">
    <div class="footer-contact">
      <?php
      foreach ($columns as $column => $data):
        if ($data['value'] === 'contact'): ?>
          <p class="list--title"><?= $site_name ?></p>
          <ul class="list--list">
            <?php if ($email): ?>
              <li class="list--item">
                <a href="mailto:<?= $email ?>"><?= $email ?></a>
              </li>
            <?php endif; ?>
            <?php if ($phone):

              $numeric = str_replace('-', '', $phone);
              $formatted = preg_match('/^(\d{3})-(\d{3})-(\d{4})$/', $phone, $matches)
                ? sprintf('(%s) %s-%s', $matches[1], $matches[2], $matches[3])
                : $phone;
              ?>
              <li class="list--item">
                <a href="tel:<?= esc_html($numeric) ?>">
                  <?= esc_html($formatted) ?>
                </a>
              </li>
            <?php
            endif; ?>
            <?php if ($address): ?>
              <li class="list--item"><?= $address ?></li>
            <?php endif; ?>
          </ul>
        <?php endif;
      endforeach; ?>
    </div>
    <div class="social-wrap">
      <h4 class="list--title"><?= $social_media_label?></h4>
      <div class="socials">
        <?php if (!empty($social_media_accounts)): ?>
          <?php foreach ($social_media_accounts as $account): ?>
            <?php
            $link = $account['link'];
            $icon = $account['icon'];
            ?>
            <?php if (!empty($link)): ?>
              <a
                href="<?= esc_url($link['url']) ?>"
                target="<?= esc_attr($link['target'] ?? '_self') ?>"
                class="link"
              >
                <?php if (!empty($icon)): ?>
                  <img
                    src="<?= esc_url($icon['url']) ?>"
                    alt="<?= esc_attr($icon['alt']) ?>"
                    class="icon"
                  />
                <?php else: ?>
                  <?= esc_html($link['title']) ?>
                <?php endif; ?>
              </a>
            <?php endif; ?>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="colophon-mobile-version">
    <?php component('footer/colophon-option-2'); ?>
  </div>
</div>
