<?php

/**
 * Component: Header
 * Variant: BLOX
 */

$brand_name = get_theme_option('brand_name');
$brand_logo = get_theme_option('brand_logo');
$home_url = home_url('/');
$main_menu_items = get_menu('header_menu_main');
$cta_menu_items = get_menu('header_menu_cta');
?>

  <div class="header-layout">

    <div class="header-brand">
      <?php if ($brand_logo): ?>
        <a class="brand-logo" href="<?= esc_url($home_url) ?>">
          <img src="<?= $brand_logo ?>" alt="<?= $brand_name ?> logo" loading="eager" />
        </a>
      <?php else: ?>
        <div class="brand-name">
          <h1><?= $brand_name ?></h1>
        </div>
      <?php endif; ?>
    </div>

    <nav class="header-nav_main">
      <ul class="header-nav_main-list">
        <?php foreach (get_menu('header_menu_main') as $item): ?>
          <li tabindex="-1" class="<?= cn('header-nav_main-list-item') ?>" >
            <?php if ($item->children): ?>
              <span class='link'><?= $item->title ?></span>
              <ul tabindex="-1" class="megamenu">
                <li>
                  <div class="wrapper">
                    <?php foreach ($item->children as $key => $child): ?>
                      <div class="group">
                        <div class="heading">
                          <?php if ($child->url == '#'): ?>
                            <span class="link"><?= $child->title ?></span>
                          <?php else: ?>
                            <a href='<?= $child->url ?>'><?= $child->title ?></a>
                          <?php endif; ?>
                        </div>
                        <ul class="links">
                          <?php foreach ($child->children ?: [] as $grandchild): ?>
                            <li><a href='<?= $grandchild->url ?>'><?= $grandchild->title ?>
                              <span class="description"><?= $grandchild->description ?></span>
                            </a></li>
                          <?php endforeach; ?>
                        </ul>
                      </div>
                    <?php endforeach; ?>
                  </div>
                </li>
              </ul>
            <?php else: ?>
              <a class="link" href='<?= $item->url ?>'><?= $item->title ?></a>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </nav>

    <nav class="header-nav_cta">
      <ul class="header-nav_cta-list">
        <?php foreach ($cta_menu_items as $item): ?>
          <li tabindex="-1" class="<?= cn('header-nav_cta-list-item') ?>" >
            <a class="<?= cn(
              'button',
              end($cta_menu_items) === $item ? 'variant--primary' : 'variant--ghost'
            ) ?>" href='<?= $item->url ?>'>
              <?= $item->title ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    </nav>

    <div class="header-mobile-menu" data-js-target="header.mobileMenu">

      <button 
        class="mobile-menu-toggle" 
        data-expanded="false"
        aria-label="Open menu"
        type="button"
      >
        <span class="line" data-position="top"></span>
        <span class="line" data-position="bottom"></span>
      </button>

      <div class="mobile-menu-root" data-lenis-prevent>
        <nav class="mobile-menu-wrapper">

          <section class="mobile-menu-nav_main">
            <ul class="stack">
              <?php foreach ($main_menu_items as $item): ?>
                <li class="header-nav_main-list-item" >
                  <?php if ($item->children): ?>
                    <span class='link'><?= $item->title ?></span>
                    <ul>
                      <li>
                        <div class="wrapper">
                          <?php foreach ($item->children as $key => $child): ?>
                            <div class="group">
                              <div class="heading">
                                <?php if ($child->url == '#'): ?>
                                  <span class="link"><?= $child->title ?></span>
                                <?php else: ?>
                                  <a href='<?= $child->url ?>'><?= $child->title ?></a>
                                <?php endif; ?>
                              </div>
                              <ul class="links">
                                <?php foreach ($child->children ?: [] as $grandchild): ?>
                                  <li><a href='<?= $grandchild->url ?>'><?= $grandchild->title ?>
                                    <span class="description"><?= $grandchild->description ?></span>
                                  </a></li>
                                <?php endforeach; ?>
                              </ul>
                            </div>
                          <?php endforeach; ?>
                        </div>
                      </li>
                    </ul>
                  <?php else: ?>
                    <a class="link" href='<?= $item->url ?>'><?= $item->title ?></a>
                  <?php endif; ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </section>

          <section class="mobile-menu-nav_cta">
            <div class="stack">
              <?php foreach ($cta_menu_items as $item): ?>
                <a class="<?= cn(
                  'button',
                  end($cta_menu_items) === $item ? 'variant--primary' : 'variant--secondary'
                ) ?>" href='<?= $item->url ?>'>
                  <?= $item->title ?>
                </a>
              <?php endforeach; ?>
            </div>
          </section>

        </nav>
      </div>

    </div>

  </div>
