<?php

/**
 * Pagination
 * @param array $args
 */

$_defaults = [
  'type' => 'load-more',
  'className' => '',
  'ajax' => [
    'callback' => '',
    'container' => '',
    'query_args' => '',
    'component_args' => '',
  ],
  'options' => [
    'per_page' => 12,
    'max_pages' => null,
  ],
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<div
  class="<?= cn('pagination', $className) ?>"
  <?= attr_if('data-variant', $type) ?>
>
  <?php if ($type == 'load-more'): ?>
    <button
      class="button"
      data-variant="secondary"
      data-js-target="pagination.loadMore"
      data-page="1"
      <?= attr_if('data-per-page', $options['per_page']) ?>
      <?= attr_if('data-max-pages', $options['max_pages']) ?>
      <?= attr_if('data-ajax-container', $ajax['container']) ?>
      <?= attr_if('data-ajax-callback', $ajax['callback']) ?>
      data-ajax-query-args='<?= wp_json_encode($ajax['query_args'], JSON_HEX_APOS | JSON_HEX_QUOT) ?>'
      data-ajax-component-args='<?= wp_json_encode($ajax['component_args'], JSON_HEX_APOS | JSON_HEX_QUOT) ?>'
      data-ajax-url="<?= esc_url(admin_url('admin-ajax.php')) ?>"
      data-ajax-nonce="<?= wp_create_nonce('load-more-posts') ?>"
    >
      <?php _e('Show more posts', 'plexible-theme-terms_controls'); ?>
    </button>
  <?php endif; ?>
</div>
