<?php
$popup_settings = get_field('popup_settings', 'option');
$popup_active = !empty($popup_settings['popup_control']);

if (!$popup_active) {
  return;
}

$passed_args = $args ?? [];
$_query = [
  'content' => [
    'has_caption' => get_field('has_caption', 'option'),
    'caption' => get_field('caption', 'option'),
    'has_title' => get_field('has_title', 'option'),
    'title' => get_field('title', 'option'),
    'has_body' => get_field('has_body', 'option'),
    'body' => get_field('body', 'option'),
    'has_footer' => get_field('has_footer', 'option'),
    'button_group' => get_field('button_group', 'option')
  ],
  'items' => get_field('item', 'option'), // Repeater items
  'figure' => get_field('figure', 'option'),
];
$props = array_merge_deep($_query, $passed_args);
$popup_options = get_field('popup_options', 'option') ?: [];
$popup_type = $popup_options['popup_type'] ?? 'none';
$popup_time = (int)($popup_options['popup_time'] ?? 0);
if ($popup_type === 'none') {
  return;
}
?>

<div class="layout-block popup-container">
  <div class="popup"
       data-js-target="popup.container"
       data-trigger="<?= esc_attr($popup_type); ?>"
       data-time="<?= esc_attr($popup_time); ?>">
    <div class="wrapper">
      <div class="layout_row">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section', 'figure' => $props['figure']]); ?>
        <div
          class="<?= cn('text-image_layout' /*$props['item_align'], $props['item_reverse']*/) ?>"
        >
          <?php if (!empty($props['items'])): ?>
            <div class="content">
              <div class="list">
                <ul class="list--list">
                  <?php foreach ($props['items'] as $item): ?>
                    <li class="list--item">
                      <?php component('copy', [
                        'has_title' => $item['has_title'],
                        'title' => $item['title'],
                        'has_body' => $item['has_body'],
                        'body' => $item['body'],
                        'has_footer' => $item['has_footer'],
                        'button_group' => $item['button_group'],
                      ]); ?>
                    </li>
                  <?php endforeach; ?>
                </ul>
              </div>
            </div>
          <?php endif; ?>

          <div class="visual">
            <?php if (!empty($props['figure']['provider'])): ?>
              <?php component('figure', [
                'src' => $props['figure'],
                'type' => 'fill',
                'shape' => 'rounded',
                'has_shadow' => true,
              ]); ?>
            <?php elseif (!empty($props['figure'])): ?>
              <div class="figure has-shadow" data-variant="fill" data-shape="rounded">
                <div class="figure_inner">
                  <img src="<?= esc_url($props['figure']['url']) ?>">
                </div>
              </div>
            <?php else: ?>
              <span class="figure-placeholder" data-label="Upload Image"></span>
            <?php endif; ?>
          </div>
        </div>
        <button class="popup-close">×</button>
      </div>
    </div>
  </div>
</div>
