<?php

/**
 * Quote
 * @param array $args
 */

$_defaults = [
  'type' => 'default',
  'align' => '',
  'content' => [],
  'attribution' => [
    'name' => '',
    'position' => '',
  ],
  'className' => '',
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);
?>

<blockquote
  class="<?= cn('quote', $className) ?>"
  <?= attr_if('data-variant', $type) ?>
  <?= attr_if('data-align', $align) ?>
>
  <?php if (!empty($content)): ?>
    <div class="quote--body">
      <?= wp_kses_post($content) ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($attribution['name']) || !empty($attribution['position'])): ?>
    <div class="quote_attribution">
      <?php if (!empty($attribution['name'])): ?>
        <p class="name"><?= $attribution['name'] ?></p>
      <?php endif; ?>
      <?php if (!empty($attribution['position'])): ?>
        <p class="position"><?= $attribution['position'] ?></p>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</blockquote>
