<?php

/**
 * Heading
 * @param array $args
 */

$_defaults = [
  /**
   * Specify alternative heading appearance
   */
  'type' => 'default',
  /**
   * Specify the heading size
   */
  'size' => 2,
  /**
   * Which HTML element to apply for the heading (h1-h6)
   */
  'as' => 'h2',
  /**
   * Custom class to pass to the component
   */
  'className' => '',
  /**
   * The text content passed to the heading
   */
  'text' => '',
  /**
   * Specify a preset animation
   */
  'motion' => '',
];

/**
 * Merge passed arguments with defaults, extract the result
 */
$params = array_merge_deep($_defaults, $args ?? []);
extract($params);

$heading_tag = $as ?: 'h2';
?>

<<?= esc_html($heading_tag) ?>
  class="<?= cn('h', $className) ?>"
  <?= attr_if('data-size', $size) ?>
  <?= attr_if('data-motion', $motion) ?>
>
  <?= esc_html($text) ?>
</<?= esc_html($heading_tag) ?>>
