<?php

function get_app_data(): array {
  $site_name = get_site_info('name');
  $theme_opts = function ($key, $default = null) {
    return get_theme_option($key) ?? $default;
  };
  return [
    'global_data' => [
      'default_theme' => match ($theme_opts('default_theme') ?? null) {
        '0' => null,
        '1' => 'light',
        '2' => 'dark',
        default => null,
      },
      'brand_name' => $site_name,
      'brand_logo' => $theme_opts('brand_logo'),
      'brand_logo_alt' => $theme_opts('brand_logo_alt'),
      'socials' => $theme_opts('social_media_accounts', []),
      'phone' => [
        'label' => $theme_opts('contact_phone_label'),
        'value' => $theme_opts('contact_phone'),
      ],
      'mail' => [
        'label' => $theme_opts('contact_email_label'),
        'value' => $theme_opts('contact_email'),
      ],
    ],

    'header_data' => [
      'menu_main' => get_menu('header_menu_main'),
      'menu_cta' => get_menu('header_menu_cta'),
      'variant' => match ($theme_opts('header_variant') ?? null) {
        '1' => 'floating',
        default => null,
      },
      'is_transparent' => $theme_opts('header_options')['header_floating_transparent'] ?? false,
      'sticky' => $theme_opts('header_options')['o_sticky'] ?? false,
      'align' => match ($theme_opts('header_options')['o_align'] ?? null) {
        '0' => 'u-align-start',
        '1' => 'u-align-center',
        '2' => 'u-align-end',
        default => null,
      },
      'space_top' => match ($theme_opts('header_opt_space_top') ?? null) {
        '0' => null,
        '2' => '--multiplier-space-top:2',
        '4' => '--multiplier-space-top:4',
        '5' => '--multiplier-space-top:5',
        '7' => '--multiplier-space-top:7',
        '10' => '--multiplier-space-top:10',
        '15' => '--multiplier-space-top:15',
        default => null,
      },
      'space_bottom' => match ($theme_opts('header_opt_space_bottom') ?? null) {
        '0' => null,
        '2' => '--multiplier-space-bottom:2',
        '4' => '--multiplier-space-bottom:4',
        '5' => '--multiplier-space-bottom:5',
        '7' => '--multiplier-space-bottom:7',
        '10' => '--multiplier-space-bottom:10',
        '15' => '--multiplier-space-bottom:15',
        default => null,
      },
      'theme' => match ($theme_opts('header_opt_theme') ?? null) {
        '0' => null,
        '1' => 'light',
        '2' => 'dark',
        default => null,
      },
      'block_id' => $theme_opts('header_opt_anchor') ? $theme_opts('header_header_opt_anchor') : null,
      'text_color' => $theme_opts('header_opt_text_color') ? '--text-color: '. $theme_opts('header_opt_text_color') : null,
      'background_color' => $theme_opts('header_opt_background_color') ? '--header-background: '. $theme_opts('header_opt_background_color') : null,
      'border' => $theme_opts('header_opt_border') ? 'has-border' : null,
      'banner' => [
        'enabled' => $theme_opts('header_banner')['is_enabled'] ?? false,
        'variant' => match ($theme_opts('header_banner')['content']['variant'] ?? null) {
          '0' => null,
          '1' => 'weather',
          default => null,
        },
      ],
    ],

    'footer_data' => [
      'current_year' => date('Y'),
      'columns' => [
        'column_1' => [
          'enable' => $theme_opts('has_column_1'),
          'value' => $theme_opts('column_1'),
        ],
        'column_2' => [
          'enable' => $theme_opts('has_column_2'),
          'value' => $theme_opts('column_2'),
        ],
        'column_3' => [
          'enable' => $theme_opts('has_column_3'),
          'value' => $theme_opts('column_3'),
        ],
        'column_4' => [
          'enable' => $theme_opts('has_column_4'),
          'value' => $theme_opts('column_4'),
        ],
      ],
      'menu_footer_group_1' => get_menu('footer_group_1'),
      'menu_footer_group_2' => get_menu('footer_group_2'),
      'menu_footer_group_3' => get_menu('footer_group_3'),
      'variant' => match ($theme_opts('footer_variant') ?? null) {
        '1' => 'option-2',
        default => null,
      },
      'theme' => match ($theme_opts('footer_opt_theme') ?? null) {
        '0' => null,
        '1' => 'light',
        '2' => 'dark',
        default => null,
      },
      'space_top' => match ($theme_opts('footer_opt_space_top') ?? null) {
        '0' => null,
        '2' => '--multiplier-space-top:2',
        '4' => '--multiplier-space-top:4',
        '5' => '--multiplier-space-top:5',
        '7' => '--multiplier-space-top:7',
        '10' => '--multiplier-space-top:10',
        '15' => '--multiplier-space-top:15',
        default => null,
      },
      'space_bottom' => match ($theme_opts('footer_opt_space_bottom') ?? null) {
        '0' => null,
        '2' => '--multiplier-space-bottom:2',
        '4' => '--multiplier-space-bottom:4',
        '5' => '--multiplier-space-bottom:5',
        '7' => '--multiplier-space-bottom:7',
        '10' => '--multiplier-space-bottom:10',
        '15' => '--multiplier-space-bottom:15',
        default => null,
      },
      'block_id' => $theme_opts('footer_opt_anchor') ? $theme_opts('footer_opt_anchor') : null,
    ],
   'popup_data' => [
     'variant' => match ($theme_opts('popup_variant') ?? null) {
      // '1' => 'option-2',
       default => null,
     },
      'theme' => match ($theme_opts('popup_opt_theme') ?? null) {
        '0' => null,
        '1' => 'light',
        '2' => 'dark',
        default => null,
      },
     'space_top' => match ($theme_opts('popup_opt_space_top') ?? null) {
       '0' => null,
       '2' => '--multiplier-space-top:2',
       '4' => '--multiplier-space-top:4',
       '5' => '--multiplier-space-top:5',
       '7' => '--multiplier-space-top:7',
       '10' => '--multiplier-space-top:10',
       '15' => '--multiplier-space-top:15',
       default => null,
     },
     'space_bottom' => match ($theme_opts('popup_opt_space_bottom') ?? null) {
       '0' => null,
       '2' => '--multiplier-space-bottom:2',
       '4' => '--multiplier-space-bottom:4',
       '5' => '--multiplier-space-bottom:5',
       '7' => '--multiplier-space-bottom:7',
       '10' => '--multiplier-space-bottom:10',
       '15' => '--multiplier-space-bottom:15',
       default => null,
     },
     'block_id' => $theme_opts('popup_opt_anchor') ? $theme_opts('popup_opt_anchor') : null,
     'text_color' => $theme_opts('popup_opt_text_color') ? '--text-color: '. $theme_opts('popup_opt_text_color') : null,
     'background_color' => $theme_opts('popup_opt_background_color') ? '--popup-background: '. $theme_opts('popup_opt_background_color') : null,
     'border' => $theme_opts('popup_opt_border') ? 'has-border' : null,
    ]
  ];
}
