<?php

/**
 * ClassName utility for constructing conditional class strings
 * Emulates `clsx` like behaviour
 *
 * @return string
 */
function cn(...$args): string {
  $classes = [];

  foreach ($args as $arg) {
    if (empty($arg)) {
      continue;
    }

    if (is_string($arg) || is_numeric($arg)) {
      $classes[] = $arg;
    } elseif (is_array($arg)) {
      foreach ($arg as $key => $value) {
        if (is_numeric($key) && $value) {
          $classes[] = $value;
        } elseif ($value) {
          $classes[] = $key;
        }
      }
    }
  }

  return implode(' ', array_unique(array_filter($classes)));
}
