<?php

/**
 * Functions and utilities for setting and manipulating colors
 */

function hexToRgb($hex) {
  $hex = str_replace('#', '', $hex);

  if (strlen($hex) == 3) {
    $hex = $hex[0] . $hex[0] . $hex[1] . $hex[1] . $hex[2] . $hex[2];
  }

  $r = hexdec(substr($hex, 0, 2));
  $g = hexdec(substr($hex, 2, 2));
  $b = hexdec(substr($hex, 4, 2));

  return "$r $g $b";
}

function is_valid_hex_color($color) {
  // return preg_match('/^#?([a-f0-9]{3}|[a-f0-9]{6})$/i', $color); // uncomment to enable 3 digit hex values
  return preg_match('/^#?([a-f0-9]{6})$/i', $color);
}
