<?php

/**
 * Functions for dealing with currency
 */

/**
 * Get currency details
 *
 * @param string $currency_code The ISO currency code
 */
function get_currency_details($currency_code) {
  switch ($currency_code) {
    case 'usd':
      return ['symbol' => '$', 'code' => 'USD'];
    case 'cad':
      return ['symbol' => '$', 'code' => 'CAD'];
    case 'aud':
      return ['symbol' => '$', 'code' => 'AUD'];
    case 'eur':
      return ['symbol' => '€', 'code' => 'EUR'];
    case 'gbp':
      return ['symbol' => '£', 'code' => 'GBP'];
    case 'jpy':
      return ['symbol' => '¥', 'code' => 'JPY'];
    default:
      return ['symbol' => '', 'code' => $currency_code];
  }
}
