<?php

namespace PlexibleTheme\Editor;

/**
 * Editor assets
 */
function editor_assets() {
  wp_enqueue_style('admin-style', get_template_directory_uri() . '/admin/admin.css');
  wp_enqueue_script('admin-script', get_template_directory_uri() . '/admin/admin.js', [], null, true);
}
add_action('admin_enqueue_scripts', __NAMESPACE__ . '\\editor_assets');

/**
 * Editor styles
 */
function editor_stylesheet() {
  $editor_css = get_template_directory_uri() . '/admin/admin.css';

  if (!$editor_css) {
    return;
  }

  // clean filename without any params url
  $cleaned_filename = explode('?', $editor_css)[0];

  // WP admin editor expect a relative path to editor file
  add_editor_style($cleaned_filename);
}
add_action('after_setup_theme', __NAMESPACE__ . '\\editor_stylesheet');

/**
 * Editor favicon
 */
add_action('admin_head', function () {
  echo '<link rel="shortcut icon" href="' .
    get_template_directory_uri() .
    '/assets/images/admin-favicon.svg" type="image/x-icon" />';
});
