<?php

/**
 * Functions and utilities for dealing with icons
 */

/**
 * Inline SVG helper
 *
 * @param string $icon_id The ID associated with the SVG symbol
 */
function get_icon($icon_id, $size = 16) {
  $sprite_path = get_template_directory() . '/assets/images/icons/sprite.svg';

  if (!file_exists($sprite_path)) {
    return '';
  }

  $svg_content = file_get_contents($sprite_path);

  if (!$svg_content) {
    return '';
  }

  // Find the symbol by ID in the sprite
  $start = strpos($svg_content, '<symbol id="' . $icon_id . '"');
  $end = strpos($svg_content, '</symbol>', $start) + 9;

  if ($start === false || $end === false) {
    return '';
  }

  // Extract the symbol content
  $symbol = substr($svg_content, $start, $end - $start);

  // Remove the <symbol> tags and return just the inner contents
  preg_match('/<symbol.*?>(.*?)<\/symbol>/is', $symbol, $matches);

  // Return the cleaned-up contents of the symbol
  return '<svg xmlns="http://www.w3.org/2000/svg" class="icon" viewBox="0 0 16 16" height="' .
    $size .
    '" width="' .
    $size .
    '">' .
    $matches[1] .
    '</svg>';
}

/**
 * ACF Icon library helper
 */
function get_acf_icon(array $icon) {
  if (empty($icon)) {
    return '';
  } ?>
  <?php ob_start(); ?>
    <div class="acf-icon">
    <?php switch ($icon['type']): case 'dashicons': ?>
      <div class="dashicons <?= esc_attr($icon['value']) ?>"></div>
    <?php break;case 'media_library': ?>
      <?php
      $values = (array) $icon['value'];
      $first_id = reset($values);
      ?>
      <div class="type_image">
        <?= wp_get_attachment_image((int) $first_id, [64, 64]) ?>
      </div>
    <?php break;case 'url': ?>
      <img src="<?= esc_url($icon['value']) ?>" alt="icon">
    <?php case 'plexible-icons_outline': ?>
    <?php case 'plexible-icons_fill': ?>
      <?php
      $icon_library = get_icon_library();
      $icon_dir = $icon_library['base_path'];
      $svg_path = $icon_dir . $icon['value'] . '.svg';
      ?>
      <?php if (file_exists($svg_path)): ?>
        <?= file_get_contents($svg_path) ?>
      <?php endif; ?>
    <?php break;default:
        echo _e('Unsupported icon type.', 'plexible-theme-terms_errors');
    endswitch; ?>
    </div>
  <?php return ob_get_clean();
}
