<?php

function get_block_option_fields(string $key = ''): array {
  return [
    // layout
    [
      'key' => "field_acc_layout_start_{$key}",
      'label' => 'Layout',
      'type' => 'accordion',
    ],
    [
      'key' => "field_opt_space_top_{$key}",
      'label' => 'Spacing Top',
      'name' => 'o_space_top',
      'type' => 'range',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'step' => '2',
      'min' => '0',
      'max' => '16',
      'default_value' => '6',
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_space_bottom_{$key}",
      'label' => 'Spacing Bottom',
      'name' => 'o_space_bottom',
      'type' => 'range',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'step' => '2',
      'min' => '0',
      'max' => '16',
      'default_value' => '6',
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_align_{$key}",
      'label' => 'Align',
      'name' => 'o_align',
      'type' => 'button_group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        0 => '<i class="dashicons dashicons-editor-alignleft"></i>',
        1 => '<i class="dashicons dashicons-editor-aligncenter"></i>',
        2 => '<i class="dashicons dashicons-editor-alignright"></i>',
      ],
      'default_value' => '',
      'return_format' => 'value',
      'layout' => 'horizontal',
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_distribute_{$key}",
      'label' => 'Distribute',
      'name' => 'o_distribute',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'allow_in_bindings' => 1,
      'choices' => [
        0 => 'Start',
        1 => 'Center',
        2 => 'End',
        3 => 'Space Between',
        4 => 'Space Around',
        5 => 'Space Evenly',
      ],
      'default_value' => 0,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_gap_{$key}",
      'label' => 'Gap',
      'name' => 'o_gap',
      'type' => 'range',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'step' => '0.25',
      'min' => '0',
      'max' => '1.5',
      'default_value' => '1',
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_acc_layout_end_{$key}",
      'label' => 'Layout',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    // styles
    [
      'key' => "field_acc_styles_start_{$key}",
      'label' => 'Styles',
      'type' => 'accordion',
    ],
    [
      'key' => "field_opt_visible_{$key}",
      'label' => 'Visible',
      'name' => 'o_visible',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'default_value' => 1,
      'ui' => 1,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_theme_{$key}",
      'label' => 'Theme',
      'name' => 'o_theme',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'allow_in_bindings' => 1,
      'choices' => [
        0 => 'Inherit',
        1 => 'Light',
        2 => 'Dark',
      ],
      'default_value' => 0,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_text_color_{$key}",
      'label' => 'Text',
      'name' => 'o_text_color',
      'type' => 'color_picker',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'allow_in_bindings' => 1,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_opt_background_{$key}",
      'label' => 'Background',
      'name' => 'o_background',
      'type' => 'group',
      'layout' => 'block',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
      'wrapper' => ['class' => 'label-x'],
      'sub_fields' => get_background_fields($key),
    ],
    [
      'key' => "field_opt_border_{$key}",
      'label' => 'Border',
      'name' => 'o_border',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_acc_styles_end_{$key}",
      'label' => 'Styles',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    // effects
    [
      'key' => "field_acc_effects_start_{$key}",
      'label' => 'Effects',
      'type' => 'accordion',
    ],
    [
      'key' => "field_acc_effects_end_{$key}",
      'label' => 'Effects',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    // scroll section
    [
      'key' => "field_acc_scroll_start_{$key}",
      'label' => 'Scroll Section',
      'type' => 'accordion',
    ],
    [
      'key' => "field_opt_anchor_{$key}",
      'label' => 'Name',
      'name' => 'o_anchor',
      'type' => 'text',
      'instructions' =>
        'Enter an ID using letters, digits, hyphens or underscores (Ex: "my-section", "another_page", or "page-1"). Note: IDs cannot start with a digit',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'maxlength' => '75',
      'allow_in_bindings' => 0,
      'prepend' => '#',
    ],
    [
      'key' => "field_acc_scroll_end_{$key}",
      'label' => 'Scroll Section',
      'type' => 'accordion',
      'endpoint' => 1,
    ],

    // code overrides
    [
      'key' => "field_acc_code_start_{$key}",
      'label' => 'Code Overrides',
      'type' => 'accordion',
    ],
    [
      'key' => "field_inline_styles_{$key}",
      'label' => 'Code',
      'name' => 'o_inline_styles',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'tabs' => 'text',
      'media_upload' => 0,
      'toolbar' => 'basic',
    ],
    [
      'key' => "field_acc_code_end_{$key}",
      'label' => 'Code Overrides',
      'type' => 'accordion',
      'endpoint' => 1,
    ],
  ];
}
