<?php

/**
 * Get Button Group
 */

function get_button_group_fields(string $key = '', string $parent_repeater = '', array $conditional_logic = []): array {
  return [
    'key' => "field_button_group_{$key}",
    'label' => 'Button Group',
    'name' => 'button_group',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'layout' => 'table',
    'min' => 1,
    'max' => 4,
    'button_label' => 'Add Button',
    'rows_per_page' => 20,
    'sub_fields' => [
      [
        'key' => "field_copy_button_link_{$key}",
        'label' => 'Link',
        'name' => 'link',
        'type' => 'link',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'return_format' => 'array',
        'parent_repeater' => "field_button_group_{$key}",
      ],
      [
        'key' => "field_copy_button_variant_{$key}",
        'label' => 'Variant',
        'name' => 'variant',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'choices' => [
          0 => 'Primary',
          1 => 'Secondary',
          7 => 'Accent',
          2 => 'Ghost',
          3 => 'White',
          4 => 'Link',
          5 => 'Outline',
          6 => 'Glass',
        ],
        'default_value' => 0,
        'allow_null' => 0,
        'layout' => 'horizontal',
        'parent_repeater' => "field_button_group_{$key}",
      ],
    ],
    ...$parent_repeater ? ['parent_repeater' => $parent_repeater] : [],
  ];
}
