<?php

/**
 * Card Options
 */

function get_card_option_fields(string $key = ''): array {
  return [
    [
      'key' => "field_background_{$key}",
      'label' => 'Background',
      'name' => 'background',
      'type' => 'group',
      'layout' => 'block',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'sub_fields' => get_background_fields($key),
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_border_{$key}",
      'label' => 'Border',
      'name' => 'border',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
      'wrapper' => ['class' => 'label-x'],
    ],
    [
      'key' => "field_icon_{$key}",
      'label' => 'Icon',
      'name' => 'icon',
      'type' => 'group',
      'layout' => 'block',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'sub_fields' => get_icon_option_fields($key),
      'wrapper' => ['class' => 'label-x'],
    ],
  ];
}
