<?php

function get_copy_fields(
  string $key = '',
  array $include = ['caption', 'title', 'body', 'footer'],
  string $parent_repeater = ''
): array {
  $all_fields = [
    'caption' => [
      [
        'key' => "field_copy_has_caption_{$key}",
        'label' => 'Has Caption',
        'name' => 'has_caption',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => "field_copy_caption_{$key}",
        'label' => 'Caption',
        'name' => 'caption',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'conditional_logic' => [
          [
            [
              'field' => "field_copy_has_caption_{$key}",
              'operator' => '==',
              'value' => '1',
            ],
          ],
        ],
        'wrapper' => ['width' => '80', 'class' => 'acf-view-cond'],
      ],
    ],
    'title' => [
      [
        'key' => "field_copy_has_title_{$key}",
        'label' => 'Has Title',
        'name' => 'has_title',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => "field_copy_title_{$key}",
        'label' => 'Title',
        'name' => 'title',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'conditional_logic' => [
          [
            [
              'field' => "field_copy_has_title_{$key}",
              'operator' => '==',
              'value' => '1',
            ],
          ],
        ],
        'wrapper' => ['width' => '80', 'class' => 'acf-view-cond'],
      ],
    ],
    'body' => [
      [
        'key' => "field_copy_has_body_{$key}",
        'label' => 'Has Body',
        'name' => 'has_body',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => "field_copy_body_{$key}",
        'label' => 'Body',
        'name' => 'body',
        'type' => 'wysiwyg',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'conditional_logic' => [
          [
            [
              'field' => "field_copy_has_body_{$key}",
              'operator' => '==',
              'value' => '1',
            ],
          ],
        ],
        'tabs' => 'visual',
        'toolbar' => 'basic',
        'media_upload' => 0,
        'delay' => 0,
        'wrapper' => ['width' => '80', 'class' => 'acf-view-cond editor-short'],
      ],
    ],
    'footer' => [
      [
        'key' => "field_copy_has_footer_{$key}",
        'label' => 'Has Footer',
        'name' => 'has_footer',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => "field_copy_button_group_{$key}",
        'label' => 'Button Group',
        'name' => 'button_group',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'conditional_logic' => [
          [
            [
              'field' => "field_copy_has_footer_{$key}",
              'operator' => '==',
              'value' => '1',
            ],
          ],
        ],
        'layout' => 'table',
        'min' => 1,
        'max' => 4,
        'button_label' => 'Add Button',
        'rows_per_page' => 20,
        'wrapper' => ['width' => '80', 'class' => 'acf-view-cond'],
        'sub_fields' => [
          [
            'key' => "field_copy_button_link_{$key}",
            'label' => 'Link',
            'name' => 'link',
            'type' => 'link',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'return_format' => 'array',
            'parent_repeater' => "field_copy_button_group_{$key}",
          ],
          [
            'key' => "field_copy_button_variant_{$key}",
            'label' => 'Variant',
            'name' => 'variant',
            'type' => 'select',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'choices' => [
              0 => 'Primary',
              1 => 'Secondary',
              7 => 'Accent',
              2 => 'Ghost',
              3 => 'White',
              4 => 'Link',
              5 => 'Outline',
              6 => 'Glass',
            ],
            'default_value' => 0,
            'allow_null' => 0,
            'layout' => 'horizontal',
            'parent_repeater' => "field_copy_button_group_{$key}",
          ],
        ],
      ],
    ],
  ];

  $fields = [];
  foreach ($include as $field_group) {
    if (isset($all_fields[$field_group])) {
      $fields = array_merge($fields, $all_fields[$field_group]);
    }
  }

  return $fields;
}
