<?php

/**
 * Get Icon Group
 */

function get_icon_fields(string $key = ''): array {
  return [
    [
      'key' => "field_has_icon_{$key}",
      'label' => 'Has Icon',
      'name' => 'has_icon',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
      'wrapper' => ['width' => '20'],
    ],
    [
      'key' => "field_group_icon_{$key}",
      'label' => 'Icons',
      'name' => 'icon',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'wrapper' => ['width' => '80'],
      'sub_fields' => [
        [
          'key' => "field_icon_src_{$key}",
          'label' => 'Icon',
          'name' => 'src',
          'type' => 'icon_picker',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'tabs' => [
            0 => 'dashicons',
            1 => 'media_library',
            2 => 'plexible-icons_outline',
            3 => 'plexible-icons_fill',
          ],
          'return_format' => 'array',
          'library' => 'all',
        ],
      ],
    ],
  ];
}

function get_icon_option_fields(string $key = ''): array {
  return [
    // size
    [
      'key' => "field_icon_size_{$key}",
      'label' => 'Size',
      'name' => 'size',
      'type' => 'button_group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        'small' => 'Small',
        'regular' => 'Regular',
        'medium' => 'Medium',
        'large' => 'Large',
      ],
      'default_value' => 'regular',
      'return_format' => 'value',
      'layout' => 'horizontal',
    ],
    // color
    [
      'key' => "field_icon_color_{$key}",
      'label' => 'Colour',
      'name' => 'color',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        'default' => 'Default',
        'subtle' => 'Subtle',
        'primary' => 'Primary',
        'accent' => 'Secondary',
        'accent' => 'Accent',
      ],
      'default_value' => 'default',
      'return_format' => 'value',
    ],
    // shape
    [
      'key' => "field_icon_shape_{$key}",
      'label' => 'Shape',
      'name' => 'shape',
      'type' => 'select',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'choices' => [
        'square' => 'Square',
        'circle' => 'Circle',
      ],
      'default_value' => 'circle',
      'return_format' => 'value',
    ],
    // background
    [
      'key' => "field_icon_background_{$key}",
      'label' => 'Background',
      'name' => 'background',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
    ],
    // border
    [
      'key' => "field_icon_border_{$key}",
      'label' => 'Border',
      'name' => 'border',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
    ],
  ];
}
