<?php

$block = BLOCK_INDEX['2'];
$uid = "gutenberg_{$block['name']}";
$post_slug = get_theme_option('custom_post_type_1_slug');

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),

  // Var 2: Image
  [
    'key' => "field_figure_{$uid}",
    'label' => 'Figure',
    'name' => 'figure',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'sub_fields' => get_figure_fields($uid),
    'conditional_logic' => [
      [
        [
          'field' => "field_var_type_{$uid}",
          'operator' => '==',
          'value' => '2',
        ],
      ],
    ],
  ],

  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_posts_{$uid}",
    'label' => 'Posts to include',
    'name' => 'posts',
    'type' => 'relationship',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'instructions' => get_acf_relationship_instructions($post_slug),
    'post_type' => [0 => $post_slug],
    'post_status' => [0 => 'publish'],
    'taxonomy' => '',
    'filters' => '',
    'return_format' => 'object',
    'min' => '0',
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default', 1 => 'Grid', 2 => 'Aside'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Card Options',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => "field_opt_card_{$uid}",
    'name' => 'var_card',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'layout' => 'block',
    'wrapper' => ['class' => 'test'],
    'sub_fields' => get_card_option_fields($uid),
  ],
  acf_accordion($uid, ['label' => 'Card Options', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
