<?php

$block = BLOCK_INDEX['9'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_text_{$uid}",
    'label' => 'Text',
    'name' => 'text',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'sub_fields' => get_copy_fields($uid, ['title', 'body', 'footer']),
    'wrapper' => ['width' => '60'],
  ],
  [
    'key' => "field_figure_{$uid}",
    'label' => 'Figure',
    'name' => 'figure',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'sub_fields' => get_figure_fields($uid),
    'wrapper' => ['width' => '40'],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'label' => 'Variant',
    'name' => 'var_type',
    'choices' => [0 => 'Default'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Layout',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'label' => 'Column Ratio',
    'name' => 'var_col_ratio',
    'choices' => [
      '50-50' => 'Equal',
      '55-60' => 'Offset',
      '40-60' => 'Two Thirds',
    ],
    'wrapper' => ['width' => '50'],
  ]),
  [
    'label' => 'Column Reverse',
    'key' => "field_var_col_reverse_{$uid}",
    'name' => 'var_col_reverse',
    'type' => 'true_false',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'ui' => 1,
    'wrapper' => ['width' => '50'],
  ],
  acf_accordion($uid, ['label' => 'Layout', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
