<?php

$block = BLOCK_INDEX['28'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_content_head_{$uid}",
    'label' => 'Head',
    'name' => 'head',
    'type' => 'textarea',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
  ],
  [
    'key' => "field_supporting_one_{$uid}",
    'label' => 'Supporting Paragraph 1',
    'name' => 'supporting_one',
    'type' => 'wysiwyg',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'tabs' => 'visual',
    'toolbar' => 'basic',
    'media_upload' => 0,
    'parent_repeater' => "field_list_{$uid}",
    'wrapper' => ['class' => 'editor-extra-short'],
  ],
  [
    'key' => "field_supporting_two_{$uid}",
    'label' => 'Supporting Paragraph 2',
    'name' => 'supporting_two',
    'type' => 'wysiwyg',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'tabs' => 'visual',
    'toolbar' => 'basic',
    'media_upload' => 0,
    'parent_repeater' => "field_list_{$uid}",
    'wrapper' => ['class' => 'editor-extra-short'],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),

  [
    'key' => "field_opt_heading_size_{$uid}",
    'label' => 'Heading Size',
    'name' => 'o_heading_size',
    'type' => 'range',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'step' => '1',
    'min' => '1',
    'max' => '6',
    'default_value' => '2',
    'wrapper' => ['class' => 'label-x'],
  ],
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
