<?php

$uid = 'child_page';

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => 'Child Page Options',
  'fields' => [
    [
      'key' => "field_has_child_{$uid}",
      'label' => 'Has Child Page',
      'name' => 'has_child',
      'type' => 'true_false',
      'instructions' => 'Enable / Disable child page for this post',
      'wpml_cf_preferences' => 1,
      'default_value' => 1,
      'ui' => 1,
      'wrapper' => ['width' => '20'],
    ],
    [
      'key' => "field_child_options_{$uid}",
      'label' => 'Child Page Options',
      'name' => 'child_options',
      'type' => 'group',
      'wrapper' => ['width' => '80'],
      'sub_fields' => [
        [
          'key' => "field_preview_cta_{$uid}",
          'label' => 'Label',
          'name' => 'label',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'required' => 1,
          'maxlength' => '',
          'placeholder' => 'Learn more',
        ],
        [
          'key' => "field_has_nav_{$uid}",
          'label' => 'Has Navigation',
          'name' => 'has_nav',
          'type' => 'true_false',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'instructions' => 'Display navigation back to the posts page.',
          'ui' => 1,
        ],
        [
          'key' => "field_has_title_{$uid}",
          'label' => 'Has Title',
          'name' => 'has_title',
          'type' => 'true_false',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'instructions' => 'Display post title on the page.',
          'ui' => 1,
        ],
      ],
      'conditional_logic' => [
        [
          [
            'field' => "field_has_child_{$uid}",
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],
  ],

  // TODO: make dynamic
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => 'team',
      ],
    ],
  ],

  'menu_order' => 1,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
