<?php

/**
 * Hero
 */

$block = BLOCK_INDEX['1'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],

      // content + figure slides (legacy)
      [
        'key' => "field_slides_{$uid}",
        'name' => 'slides',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'button_label' => 'Add Slide',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_slides_content_{$uid}",
            'label' => 'Content',
            'name' => 'content',
            'type' => 'group',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['width' => '60'],
            'sub_fields' => get_copy_fields($uid),
          ],
          [
            'key' => "field_slides_figure_{$uid}",
            'label' => 'Figure',
            'name' => 'figure',
            'type' => 'group',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['width' => '40'],
            'sub_fields' => [
              [
                'key' => "field_slides_figure_provider_{$uid}",
                'label' => 'Video/Image Provider',
                'name' => 'provider',
                'type' => 'select',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
                'required' => 1,
                'choices' => [
                  'youtube' => 'YouTube',
                  'vimeo' => 'Vimeo',
                  'local-video' => 'Local Video',
                  'local-image' => 'Local Image',
                  'lottie' => 'Lottie',
                ],
                'default_value' => 'local-video',
                'parent_repeater' => "field_slides_{$uid}",
              ],
              [
                'key' => "field_slides_figure_provider_vimeo_{$uid}",
                'label' => 'Vimeo Embed',
                'name' => 'source_vimeo',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'type' => 'number',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => "field_slides_figure_provider_{$uid}",
                      'operator' => '==',
                      'value' => 'vimeo',
                    ],
                  ],
                ],
                'parent_repeater' => "field_slides_{$uid}",
              ],
              [
                'key' => "field_slides_figure_provider_youtube_{$uid}",
                'label' => 'Youtube Embed',
                'name' => 'source_youtube',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'type' => 'text',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => "field_slides_figure_provider_{$uid}",
                      'operator' => '==',
                      'value' => 'youtube',
                    ],
                  ],
                ],
                'parent_repeater' => "field_slides_{$uid}",
              ],
              [
                'key' => "field_slides_figure_provider_video_{$uid}",
                'label' => 'Local Video Embed',
                'name' => 'source_local_video',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'type' => 'file',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => "field_slides_figure_provider_{$uid}",
                      'operator' => '==',
                      'value' => 'local-video',
                    ],
                  ],
                ],
                'return_format' => 'url',
                'mime_types' => ACF_CONSTANTS['ACCEPTED_VIDEO_FILETYPES'],
                'parent_repeater' => "field_slides_{$uid}",
              ],
              [
                'key' => "field_slides_figure_provider_image_{$uid}",
                'label' => 'Local Image Embed',
                'name' => 'source_local_image',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'type' => 'image',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => "field_slides_figure_provider_{$uid}",
                      'operator' => '==',
                      'value' => 'local-image',
                    ],
                  ],
                ],
                'return_format' => 'url',
                'library' => 'all',
                'mime_types' => ACF_CONSTANTS['ACCEPTED_IMAGE_FILETYPES'],
                'parent_repeater' => "field_slides_{$uid}",
              ],
              [
                'key' => "field_slides_figure_provider_lottie_{$uid}",
                'label' => 'Lottie Embed',
                'name' => 'source_lottie',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'type' => 'text',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => "field_slides_figure_provider_{$uid}",
                      'operator' => '==',
                      'value' => 'lottie',
                    ],
                  ],
                ],
                'parent_repeater' => "field_slides_{$uid}",
              ],
            ],
          ],
        ],
        'conditional_logic' => [
          [
            [
              'field' => "field_var_type_{$uid}",
              'operator' => '==',
              'value' => '0',
            ],
          ],
        ],
      ],

      // figure only slides (new)
      [
        'key' => "field_hero_{$uid}",
        'name' => 'hero',
        'type' => 'group',
        'sub_fields' => [
          [
            'key' => "field_hero_content_{$uid}",
            'label' => 'Content',
            'name' => 'content',
            'type' => 'group',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['width' => '60'],
            'sub_fields' => get_copy_fields($uid),
          ],
          [
            'key' => "field_hero_figure_{$uid}",
            'label' => 'Figure',
            'name' => 'figure',
            'type' => 'repeater',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'layout' => 'block',
            'min' => 1,
            'max' => 6,
            'button_label' => 'Add Figure',
            'wrapper' => ['width' => '40'],
            'sub_fields' => get_figure_fields($uid, [], "field_hero_figure_{$uid}"),
            'conditional_logic' => [
              [
                [
                  'field' => "field_var_type_{$uid}",
                  'operator' => '!=',
                  'value' => '0',
                ],
                [
                  'field' => "field_var_type_{$uid}",
                  'operator' => '!=',
                  'value' => '3',
                ],
              ],
            ],
          ],
          [
            'key' => "field_hero_gallery_{$uid}",
            'label' => 'Gallery',
            'name' => 'gallery',
            'type' => 'gallery',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'min' => 9,
            'max' => 12,
            'insert' => 'append',
            'return_format' => 'array',
            'wrapper' => ['width' => '40'],
            'conditional_logic' => [
              [
                [
                  'field' => "field_var_type_{$uid}",
                  'operator' => '==',
                  'value' => '3',
                ],
              ],
            ],
          ],
        ],
        'conditional_logic' => [
          [
            [
              'field' => "field_var_type_{$uid}",
              'operator' => '!=',
              'value' => '0',
            ],
          ],
        ],
      ],

      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Split',
          2 => 'BLOX',
          3 => 'Parallax Grid',
          4 => 'Lower Third',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid),
  ),
  'min' => '',
  'max' => '',
];
