<?php

/**
 * Text Grid
 */

$block = BLOCK_INDEX['7'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_text_items_{$uid}",
        'label' => 'Items',
        'name' => 'item',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'button_label' => 'Add Text Item',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_item_has_icon_{$uid}",
            'label' => 'Has Icon',
            'name' => 'item_has_icon',
            'type' => 'true_false',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'ui' => 1,
            'parent_repeater' => "field_text_items_{$uid}",
            'wrapper' => ['width' => '20'],
          ],
          [
            'key' => "field_item_icon_{$uid}",
            'label' => 'Icon',
            'name' => 'item_icon',
            'type' => 'icon_picker',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => [
              0 => 'dashicons',
              1 => 'media_library',
              2 => 'plexible-icons_outline',
              3 => 'plexible-icons_fill',
            ],
            'return_format' => 'array',
            'library' => 'all',
            'parent_repeater' => "field_text_items_{$uid}",
            'wrapper' => ['width' => '80'],
          ],
          [
            'key' => "field_item_title_{$uid}",
            'label' => 'Title',
            'name' => 'item_title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_text_items_{$uid}",
          ],
          [
            'key' => "field_item_body_{$uid}",
            'label' => 'Body',
            'name' => 'item_body',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['class' => 'editor-short'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'parent_repeater' => "field_text_items_{$uid}",
          ],
        ],
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Two',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_var_column_breakpoint_{$uid}",
        'label' => 'Column Breakpoint',
        'name' => 'var_column_breakpoint',
        'type' => 'range',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'default_value' => '288',
        'min' => '80',
        'max' => '640',
        'step' => '1',
        'append' => 'px',
      ],
    ],
    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
