<?php

/**
 * Text / Image
 */

$block = BLOCK_INDEX['9'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_items_{$uid}",
        'label' => 'Items',
        'name' => 'item',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'button_label' => 'Add Text Item',
        'rows_per_page' => 20,
        'sub_fields' => get_copy_fields($uid, ['title', 'body', 'footer']),
        'wrapper' => ['width' => '60'],
      ],
      [
        'key' => "field_figure_{$uid}",
        'label' => 'Figure',
        'name' => 'figure',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'sub_fields' => get_figure_fields($uid),
        'wrapper' => ['width' => '40'],
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'BLOX',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    // variant customization
    [
      [
        'key' => "field_acc_var_custom_start_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_var_item_align_{$uid}",
        'label' => 'Item Align',
        'name' => 'var_item_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'instructions' => 'Horizontal alignment of the Text/Figure.',
        'choices' => [
          0 => 'Start',
          1 => 'Center',
          2 => 'End',
        ],
        'default_value' => 1,
      ],
      [
        'key' => "field_var_item_reverse_{$uid}",
        'label' => 'Reverse Columns',
        'name' => 'var_item_reverse',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'instructions' => 'Reverse the order of the columns (Figure before Text).',
        'ui' => 1,
      ],
      [
        'key' => "field_acc_var_custom_end_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
