<?php

/**
 * Vertical Carousel
 */

$block = BLOCK_INDEX['12'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_items_{$uid}",
        'label' => 'Slides',
        'name' => 'item',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'wrapper' => ['width' => '50'],
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'collapsed' => "field_items_title_{$uid}",
        'button_label' => 'Add Slide',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_items_caption_{$uid}",
            'label' => 'Caption',
            'name' => 'caption',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_items_{$uid}",
          ],
          [
            'key' => "field_items_title_{$uid}",
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_items_{$uid}",
          ],
          [
            'key' => "field_items_content_{$uid}",
            'label' => 'Content',
            'name' => 'content',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['class' => 'editor-short'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'parent_repeater' => "field_items_{$uid}",
          ],
          [
            'key' => "field_items_link_{$uid}",
            'label' => 'Link',
            'name' => 'link',
            'type' => 'link',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'return_format' => 'array',
            'parent_repeater' => "field_items_{$uid}",
          ],
        ],
      ],
      [
        'key' => "field_image_{$uid}",
        'label' => 'Image',
        'name' => 'image',
        'type' => 'image',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'wrapper' => ['width' => '50'],
        'return_format' => 'array',
        'mime_types' => '',
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
