<?php

/**
 * Text
 */

$block = BLOCK_INDEX['14'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_custom_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
