<?php

/**
 * Checklist
 */

$block = BLOCK_INDEX['16'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_list_{$uid}",
        'label' => 'Checklist',
        'name' => 'list',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'button_label' => 'Add Checklist Item',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_list_item_{$uid}",
            'label' => 'Checklist Item',
            'name' => 'list_item',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_list_{$uid}",
          ],
        ],
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // variant customization
    [
      [
        'key' => "field_acc_var_custom_start_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_list_size_{$uid}",
        'label' => 'List Size',
        'name' => 'var_list_size',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Small',
        ],
        'default_value' => 0,
        'allow_null' => 0,
      ],
      [
        'key' => "field_var_background_image_{$uid}",
        'label' => 'Background Image',
        'name' => 'var_background_image',
        'type' => 'image',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'return_format' => 'url',
        'library' => 'all',
        'allow_in_bindings' => 1,
        'preview_size' => 'medium',
      ],
      [
        'key' => "field_acc_var_custom_end_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
