<?php

/**
 * Single Image
 */

$block = BLOCK_INDEX['17'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_group_card_{$uid}",
        'label' => 'Cards',
        'name' => 'cards',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'pagination' => 0,
        'min' => 1,
        'max' => 0,
        'collapsed' => '',
        'button_label' => 'Add Card',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_icon_{$uid}",
            'label' => 'Card Icon',
            'name' => 'icon_lib',
            'type' => 'icon_picker',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'tabs' => [
              0 => 'dashicons',
              1 => 'media_library',
            ],
            'return_format' => 'array',
            'library' => 'all',
            'parent_repeater' => "field_group_card_{$uid}",
          ],

          [
            'key' => "field_title_{$uid}",
            'label' => 'Card Title',
            'name' => 'title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_group_card_{$uid}",
          ],
          [
            'key' => "field_excerpt_{$uid}",
            'label' => 'Card Excerpt',
            'name' => 'excerpt',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'wrapper' => ['class' => 'editor-short'],
            'parent_repeater' => "field_group_card_{$uid}",
          ],
          [
            'key' => "field_link_{$uid}",
            'label' => 'Card Link',
            'name' => 'link',
            'type' => 'link',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'return_format' => 'array',
            'parent_repeater' => "field_group_card_{$uid}",
          ],
        ],
      ],

      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Slider',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_icon_size_{$uid}",
        'label' => 'Icon Size',
        'name' => 'var_icon_size',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          16 => '16',
          20 => '20',
          24 => '24',
          32 => '32',
        ],
        'default_value' => 16,
      ],
      [
        'key' => "field_icon_background_{$uid}",
        'label' => 'Icon Background',
        'name' => 'var_icon_background',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid),
  ),
  'min' => '',
  'max' => '',
];
