<?php

/**
 * Concierge
 */

$block = BLOCK_INDEX['18'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_builder_start_{$uid}",
        'label' => 'Step Builder',
        'type' => 'accordion',
      ],
      [
        'key' => 'field_67992791f515b',
        'label' => 'Step Mode',
        'name' => 'step_multi_mode',
        'aria-label' => '',
        'type' => 'select',
        'instructions' => '',
        'required' => 0,
        'conditional_logic' => 0,
        'wrapper' => [
          'width' => '',
          'class' => '',
          'id' => '',
        ],
        'wpml_cf_preferences' => 1,
        'choices' => [
          'true' => 'Multi Choice Selection',
          'false' => 'Single Choice Selection',
        ],
        'default_value' => 'false',
        'return_format' => 'value',
        'multiple' => 0,
        'allow_null' => 0,
        'allow_in_bindings' => 1,
        'ui' => 0,
        'ajax' => 0,
        'placeholder' => '',
      ],
      [
        'key' => 'field_679008f3e4a48',
        'label' => 'Steps',
        'name' => 'steps',
        'aria-label' => '',
        'type' => 'repeater',
        'instructions' => '',
        'required' => 1,
        'conditional_logic' => 0,
        'wrapper' => [
          'width' => '',
          'class' => '',
          'id' => '',
        ],
        'wpml_cf_preferences' => 1,
        'layout' => 'block',
        'min' => 1,
        'max' => 0,
        'collapsed' => 'field_6790095fe4a4a',
        'button_label' => 'Add Step',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => 'field_6790090ee4a49',
            'label' => 'Has Step Title',
            'name' => 'has_step_title',
            'aria-label' => '',
            'type' => 'true_false',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => [
              'width' => '',
              'class' => '',
              'id' => '',
            ],
            'wpml_cf_preferences' => 1,
            'message' => '',
            'default_value' => 0,
            'allow_in_bindings' => 0,
            'ui_on_text' => '',
            'ui_off_text' => '',
            'ui' => 1,
            'parent_repeater' => 'field_679008f3e4a48',
          ],
          [
            'key' => 'field_6790095fe4a4a',
            'label' => 'Step Title',
            'name' => 'step_title',
            'aria-label' => '',
            'type' => 'text',
            'instructions' => '',
            'required' => 1,
            'conditional_logic' => [
              [
                [
                  'field' => 'field_6790090ee4a49',
                  'operator' => '==',
                  'value' => '1',
                ],
              ],
            ],
            'wrapper' => [
              'width' => '',
              'class' => '',
              'id' => '',
            ],
            'wpml_cf_preferences' => 2,
            'default_value' => '',
            'maxlength' => '',
            'allow_in_bindings' => 0,
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'parent_repeater' => 'field_679008f3e4a48',
          ],
          [
            'key' => 'field_679009c6e4a4b',
            'label' => 'Step Choices',
            'name' => 'step_choices',
            'aria-label' => '',
            'type' => 'repeater',
            'instructions' => '',
            'required' => 1,
            'conditional_logic' => 0,
            'wrapper' => [
              'width' => '',
              'class' => '',
              'id' => '',
            ],
            'wpml_cf_preferences' => 1,
            'layout' => 'block',
            'min' => 1,
            'max' => 0,
            'collapsed' => 'field_679009fee4a4c',
            'button_label' => 'Add Choice',
            'rows_per_page' => 20,
            'parent_repeater' => 'field_679008f3e4a48',
            'sub_fields' => [
              [
                'key' => 'field_67900a32e4a4d',
                'label' => 'Choice Icon',
                'name' => 'step_choice_icon',
                'aria-label' => '',
                'type' => 'icon_picker',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => [
                  'width' => '',
                  'class' => '',
                  'id' => '',
                ],
                'wpml_cf_preferences' => 2,
                'tabs' => [
                  0 => 'dashicons',
                  1 => 'media_library',
                ],
                'return_format' => 'array',
                'allow_in_bindings' => 0,
                'library' => 'all',
                'default_value' => [
                  'type' => null,
                  'value' => null,
                ],
                'parent_repeater' => 'field_679009c6e4a4b',
              ],
              [
                'key' => 'field_679009fee4a4c',
                'label' => 'Choice Title',
                'name' => 'step_choice_title',
                'aria-label' => '',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => [
                  'width' => '',
                  'class' => '',
                  'id' => '',
                ],
                'wpml_cf_preferences' => 2,
                'default_value' => '',
                'maxlength' => '',
                'allow_in_bindings' => 0,
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'parent_repeater' => 'field_679009c6e4a4b',
              ],
              [
                'key' => 'field_67900a6ae4a4e',
                'label' => 'Choice Subtitle',
                'name' => 'step_choice_subtitle',
                'aria-label' => '',
                'type' => 'textarea',
                'instructions' =>
                  'Short subtitle to be included under the Choice Title. For lengthy information use "More Info" below.',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => [
                  'width' => '',
                  'class' => '',
                  'id' => '',
                ],
                'wpml_cf_preferences' => 2,
                'default_value' => '',
                'maxlength' => '',
                'allow_in_bindings' => 1,
                'rows' => '',
                'placeholder' => '',
                'new_lines' => '',
                'parent_repeater' => 'field_679009c6e4a4b',
              ],
              [
                'key' => 'field_6797ad39886fe',
                'label' => 'Has Choice More Info',
                'name' => 'step_choice_has_more_info',
                'aria-label' => '',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => [
                  'width' => '',
                  'class' => '',
                  'id' => '',
                ],
                'wpml_cf_preferences' => 1,
                'message' => '',
                'default_value' => 0,
                'allow_in_bindings' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
                'ui' => 1,
                'parent_repeater' => 'field_679009c6e4a4b',
              ],
              [
                'key' => 'field_6797b148886ff',
                'label' => 'Choice More Info',
                'name' => 'step_choice_more_info',
                'aria-label' => '',
                'type' => 'wysiwyg',
                'instructions' => '',
                'required' => 1,
                'conditional_logic' => [
                  [
                    [
                      'field' => 'field_6797ad39886fe',
                      'operator' => '==',
                      'value' => '1',
                    ],
                  ],
                ],
                'wrapper' => [
                  'width' => '',
                  'class' => '',
                  'id' => '',
                ],
                'wpml_cf_preferences' => 2,
                'default_value' => '',
                'allow_in_bindings' => 0,
                'tabs' => 'visual',
                'toolbar' => 'basic',
                'media_upload' => 0,
                'delay' => 0,
                'parent_repeater' => 'field_679009c6e4a4b',
              ],
            ],
          ],
        ],
      ],
      [
        'key' => "field_acc_builder_end_{$uid}",
        'label' => 'Step Builder',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_complete_start_{$uid}",
        'label' => 'Step Completion',
        'type' => 'accordion',
      ],
      [
        'key' => 'field_6793c7e3954a0',
        'label' => 'Has Step Form Title',
        'name' => 'has_step_form_title',
        'aria-label' => '',
        'type' => 'true_false',
        'instructions' => '',
        'required' => 0,
        'conditional_logic' => 0,
        'wrapper' => [
          'width' => '',
          'class' => '',
          'id' => '',
        ],
        'wpml_cf_preferences' => 1,
        'message' => '',
        'default_value' => 0,
        'allow_in_bindings' => 0,
        'ui_on_text' => '',
        'ui_off_text' => '',
        'ui' => 1,
      ],
      [
        'key' => 'field_6793c80f954a1',
        'label' => 'Step Form Title',
        'name' => 'step_form_title',
        'aria-label' => '',
        'type' => 'text',
        'instructions' => '',
        'required' => 1,
        'conditional_logic' => [
          [
            [
              'field' => 'field_6793c7e3954a0',
              'operator' => '==',
              'value' => '1',
            ],
          ],
        ],
        'wrapper' => [
          'width' => '',
          'class' => '',
          'id' => '',
        ],
        'wpml_cf_preferences' => 2,
        'default_value' => '',
        'maxlength' => '',
        'allow_in_bindings' => 0,
        'placeholder' => '',
        'prepend' => '',
        'append' => '',
      ],
      [
        'key' => 'field_679010c69c5de',
        'label' => 'Step Form',
        'name' => 'step_form_id',
        'aria-label' => '',
        'type' => 'number',
        'instructions' => 'ID of the Formidable form to include on completion of steps above. (Formidable > Forms)',
        'required' => 1,
        'conditional_logic' => 0,
        'wrapper' => [
          'width' => '',
          'class' => '',
          'id' => '',
        ],
        'wpml_cf_preferences' => 1,
        'default_value' => '',
        'min' => '',
        'max' => '',
        'allow_in_bindings' => 0,
        'placeholder' => '',
        'step' => '',
        'prepend' => '',
        'append' => '',
      ],
      [
        'key' => "field_acc_complete_end_{$uid}",
        'label' => 'Step Completion',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),

  'min' => '',
  'max' => '',
];
