<?php

/**
 * FAQ
 */

$block = BLOCK_INDEX['20'];
$uid = $block['name'];
$accordion_items_min = 1;
$accordion_items_max = 20;
$post_title = MODULES['faq']['title'];
$post_slug = MODULES['faq']['slug'];
$aside_variant_condition = [
  [
    [
      'field' => "field_var_type_{$uid}",
      'operator' => '==',
      'value' => '1',
    ],
  ],
];

$default_variant_condition = [
  [
    [
      'field' => "field_var_type_{$uid}",
      'operator' => '!=',
      'value' => '1',
    ],
  ],
];
return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_accordion_mode_{$uid}",
        'label' => 'Accordion Mode',
        'name' => 'accordion_mode',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'instructions' =>
          'Which accordion style would you like? Options between Single (One open at a time) or Multi (Multiple open at a time)',
        'required' => 1,
        'choices' => [
          'single' => 'Single Expand',
          'multi' => 'Multi Expand',
        ],
        'default_value' => 'single',
        'return_format' => 'value',
      ],
      [
        'key' => "field_accordion_items_{$uid}",
        'label' => 'Accordion Items',
        'name' => 'posts',
        'type' => 'relationship',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'instructions' => get_acf_relationship_instructions($post_slug, $post_title),
        'post_type' => [0 => $post_slug],
        'post_status' => [0 => 'publish'],
        'taxonomy' => '',
        'filters' => '',
        'return_format' => 'object',
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_custom_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Aside',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    // variant customization
    [],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],

    get_option_fields($uid, [], 'default', [
      'disable_background_on_aside' => true,
    ]),

    [
      [
        'key' => "field_acc_aside_image_start_{$uid}",
        'label' => 'Aside Image',
        'type' => 'accordion',
        'conditional_logic' => $aside_variant_condition,
      ],
      [
        'key' => "field_aside_image_{$uid}",
        'label' => 'Image',
        'name' => 'aside_image',
        'type' => 'image',
        'return_format' => 'array',
        'preview_size' => 'medium',
        'mime_types' => ACF_CONSTANTS['ACCEPTED_IMAGE_FILETYPES'],
        'conditional_logic' => $aside_variant_condition,
      ],
      [
        'key' => "field_acc_aside_image_end_{$uid}",
        'label' => 'Aside Image',
        'type' => 'accordion',
        'endpoint' => 1,
        'conditional_logic' => $aside_variant_condition,
      ],
    ],

  ),
  'min' => '',
  'max' => '',
];
