<?php

/**
 * Table
 */

$block = BLOCK_INDEX['25'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],

      [
        'key' => "field_table_{$uid}",
        'label' => 'Table',
        'name' => 'table',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'sub_fields' => [
          [
            'key' => "field_table_head_{$uid}",
            'label' => 'Table Head',
            'name' => 'table_head',
            'type' => 'group',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'layout' => 'table',
            'sub_fields' => [
              [
                'key' => "field_table_head_1_{$uid}",
                'label' => 'Thead 1',
                'name' => 'thead_1',
                'type' => 'text',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              ],
              [
                'key' => "field_table_head_2_{$uid}",
                'label' => 'Thead 2',
                'name' => 'thead_2',
                'type' => 'text',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              ],
              [
                'key' => "field_table_head_3_{$uid}",
                'label' => 'Thead 3',
                'name' => 'thead_3',
                'type' => 'text',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              ],
              [
                'key' => "field_table_head_4_{$uid}",
                'label' => 'Thead 4',
                'name' => 'thead_4',
                'type' => 'text',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
              ],
            ],
          ],
          [
            'key' => "field_table_body_{$uid}",
            'label' => 'Table Body',
            'name' => 'table_body',
            'type' => 'repeater',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'layout' => 'block',
            'min' => 1,
            'max' => 0,
            'button_label' => 'Add Table Row',
            'sub_fields' => [
              [
                'key' => "field_table_row_{$uid}",
                'name' => 'row',
                'type' => 'group',
                'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                'layout' => 'table',
                'sub_fields' => [
                  [
                    'key' => "field_table_cell_1_{$uid}",
                    'label' => 'Cell Head',
                    'name' => 'cell_1',
                    'type' => 'text',
                    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  ],
                  [
                    'key' => "field_table_col2_{$uid}",
                    'label' => 'Cell One',
                    'name' => 'cell_2',
                    'type' => 'text',
                    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  ],
                  [
                    'key' => "field_table_col3_{$uid}",
                    'label' => 'Cell Two',
                    'name' => 'cell_3',
                    'type' => 'text',
                    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  ],
                  [
                    'key' => "field_table_col4_{$uid}",
                    'label' => 'Cell Three',
                    'name' => 'cell_4',
                    'type' => 'text',
                    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
                  ],
                ],
              ],
            ],
          ],
        ],
      ],

      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_custom_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
        ],
        'default_value' => 0,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    // variant customization
    [],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
